/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Feature;
import org.apache.batik.svggen.font.table.FeatureRecord;
import org.apache.batik.svggen.font.table.LangSys;

public class FeatureList {
    private int featureCount;
    private FeatureRecord[] featureRecords;
    private Feature[] features;

    public FeatureList(RandomAccessFile randomAccessFile, int n) throws IOException {
        randomAccessFile.seek(n);
        this.featureCount = randomAccessFile.readUnsignedShort();
        this.featureRecords = new FeatureRecord[this.featureCount];
        this.features = new Feature[this.featureCount];
        int n2 = 0;
        while (n2 < this.featureCount) {
            this.featureRecords[n2] = new FeatureRecord(randomAccessFile);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.featureCount) {
            this.features[n3] = new Feature(randomAccessFile, n + this.featureRecords[n3].getOffset());
            ++n3;
        }
    }

    public Feature findFeature(LangSys langSys, String string) {
        if (string.length() != 4) {
            return null;
        }
        int n = string.charAt(0) << 24 | string.charAt(1) << 16 | string.charAt(2) << 8 | string.charAt(3);
        int n2 = 0;
        while (n2 < this.featureCount) {
            if (this.featureRecords[n2].getTag() == n && langSys.isFeatureIndexed(n2)) {
                return this.features[n2];
            }
            ++n2;
        }
        return null;
    }
}

