/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxwsri.generators;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.LaunchUtil;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IJavaToWsdlGenerator;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.stp.sc.jaxwsri.properties.SCJAXWSRIPropertyPage;

public class JAXWSRIJavaToWsdlGenerator
implements IJavaToWsdlGenerator {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JAXWSRIJavaToWsdlGenerator.class);

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void run(IPath path, IProject project) throws CoreException {
        try {
            IFile javaFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            ICompilationUnit cu = JDTUtils.getJavaUnitFromFile((IFile)javaFile);
            IType type = cu.findPrimaryType();
            if (type.isInterface()) {
                LOG.info((Object)("can not generate WSDL from interface " + type.getElementName()));
                return;
            }
            LOG.info((Object)("generate WSDL for " + path.toString()));
            IContainer wsdlLocation = JaxWsWorkspaceManager.getWSDLGenFolder((IPath)path, (IProject)project);
            LOG.info((Object)("WSDL location is: " + wsdlLocation));
            IJavaProject javaProject = JDTUtils.findJavaProject((String)project.getName());
            ArrayList<String> args = new ArrayList<String>();
            args.add("-r");
            args.add(wsdlLocation.getLocation().toOSString());
            String srcDir = JaxWsWorkspaceManager.getSrcFolder((IProject)project).getLocation().toOSString();
            args.add("-s");
            args.add(srcDir);
            String classPath = JDTUtils.getProjectClasspathAsString((IProject)project);
            LOG.debug((Object)("classpaths passed to j2w:" + classPath));
            args.add("-cp");
            args.add(classPath);
            String soap12 = project.getPersistentProperty(SCJAXWSRIPropertyPage.PROPERTY_KEY_SOAP_OPTION);
            LOG.debug((Object)("soap12 from project: " + soap12));
            boolean isSOAP12 = false;
            if (soap12 == null) {
                if (PreferencesAccessor.getSoap12Option()) {
                    soap12 = "anyValue";
                    LOG.debug((Object)"soap12 is needed.");
                    isSOAP12 = true;
                }
            } else if (soap12.equals("SOAP 1.2")) {
                LOG.debug((Object)"soap12 is needed by project");
                isSOAP12 = true;
            }
            if (isSOAP12) {
                args.add("-extension");
                args.add("-wsdl:Xsoap1.2");
            } else {
                args.add("-wsdl");
            }
            String clsName = JDTUtils.getJavaClassNameFromFile((IFile)javaFile);
            LOG.debug((Object)("target cls name:" + clsName));
            if (clsName == null) {
                throw new Exception("failed to get java class name");
            }
            args.add(clsName);
            LaunchUtil.launchJavaProgram((IJavaProject)javaProject, (String)"com.sun.tools.ws.WsGen", null, (String[])args.toArray(new String[0]), null);
            LOG.debug((Object)"merge the geneared wsdl and schema file");
            project.refreshLocal(2, null);
        }
        catch (Throwable e) {
            LOG.error((Object)"JAX-WS RI Java To Wsdl Generation failure", e);
        }
    }
}

