/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.webbrowser;

import java.util.Iterator;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WebBrowserUtil;
import org.eclipse.wst.server.ui.internal.webbrowser.SwitchDefaultBrowserAction;

public class SwitchBrowserWorkbenchAction
implements IWorkbenchWindowPulldownDelegate2 {
    private Menu fMenu;
    protected boolean recreateMenu = false;

    public void dispose() {
        this.setMenu(null);
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }

    public void init(IWorkbenchWindow window) {
    }

    protected void addToMenu(Menu menu, IAction action, int accelerator) {
        StringBuffer label = new StringBuffer();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append(action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(menu, -1);
    }

    protected void fillMenu(Menu menu) {
        int i = 0;
        if (WebBrowserUtil.canUseInternalWebBrowser()) {
            this.addToMenu(menu, (IAction)new SwitchDefaultBrowserAction(null, WebBrowserPreference.getBrowserChoice() == 0, null), i++);
        }
        IBrowserDescriptor current = BrowserManager.getInstance().getCurrentWebBrowser();
        BrowserManager browserManager = BrowserManager.getInstance();
        Iterator iterator = browserManager.getWebBrowsers().iterator();
        while (iterator.hasNext()) {
            IBrowserDescriptor browser = (IBrowserDescriptor)iterator.next();
            this.addToMenu(menu, (IAction)new SwitchDefaultBrowserAction(browser, WebBrowserPreference.getBrowserChoice() != 0 && browser.equals(current), browserManager), i++);
        }
    }

    private void initMenu() {
        this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                SwitchBrowserWorkbenchAction.this.fillMenu(m);
                SwitchBrowserWorkbenchAction.this.recreateMenu = false;
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run(IAction action) {
    }

    public Menu getMenu(Menu parent) {
        this.setMenu(new Menu(parent));
        this.initMenu();
        return this.fMenu;
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.initMenu();
        return this.fMenu;
    }
}

