/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.gmf.internal.xpand.ast.Advice;
import org.eclipse.gmf.internal.xpand.ast.Definition;
import org.eclipse.gmf.internal.xpand.ast.ImportDeclaration;
import org.eclipse.gmf.internal.xpand.ast.NamespaceImport;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.TypeNameUtil;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template
extends SyntaxElement
implements XpandResource {
    private final NamespaceImport[] imports;
    private final Definition[] definitions;
    private final ImportDeclaration[] extensions;
    private final Advice[] advices;
    private String qualifiedName;
    private String[] commonPrefixes = null;
    String[] importedExtensions = null;

    public ImportDeclaration[] getExtensions() {
        return this.extensions;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.qualifiedName == null ? this.getFileName() : this.qualifiedName;
    }

    public void setFullyQualifiedName(String name) {
        this.qualifiedName = name;
    }

    public Template(int start, int end, int line, NamespaceImport[] imports, ImportDeclaration[] extensions, Definition[] definitions, Advice[] advices) {
        super(start, end, line);
        AbstractDefinition element;
        this.imports = imports;
        this.extensions = extensions;
        AbstractDefinition[] abstractDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            element = abstractDefinitionArray[n2];
            element.setOwner(this);
            ++n2;
        }
        this.definitions = definitions;
        abstractDefinitionArray = advices;
        n = advices.length;
        n2 = 0;
        while (n2 < n) {
            element = abstractDefinitionArray[n2];
            element.setOwner(this);
            ++n2;
        }
        this.advices = advices;
    }

    @Override
    public XpandDefinition[] getDefinitions() {
        return this.definitions;
    }

    public NamespaceImport[] getImports() {
        return this.imports;
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        AbstractDefinition element;
        ctx = (XpandExecutionContext)ctx.cloneWithResource(this);
        AbstractDefinition[] abstractDefinitionArray = this.definitions;
        int n = this.definitions.length;
        int n2 = 0;
        while (n2 < n) {
            element = abstractDefinitionArray[n2];
            element.analyze(ctx, issues);
            ++n2;
        }
        abstractDefinitionArray = this.advices;
        n = this.advices.length;
        n2 = 0;
        while (n2 < n) {
            element = abstractDefinitionArray[n2];
            ((Advice)element).analyze(ctx, issues);
            ++n2;
        }
    }

    @Override
    public String[] getImportedNamespaces() {
        if (this.commonPrefixes == null) {
            ArrayList<String> l = new ArrayList<String>();
            String thisNs = TypeNameUtil.withoutLastSegment(this.getFullyQualifiedName());
            if (thisNs != null) {
                l.add(thisNs);
            }
            NamespaceImport[] namespaceImportArray = this.getImports();
            int n = namespaceImportArray.length;
            int n2 = 0;
            while (n2 < n) {
                NamespaceImport anImport = namespaceImportArray[n2];
                l.add(anImport.getImportString());
                ++n2;
            }
            this.commonPrefixes = l.toArray(new String[l.size()]);
        }
        return this.commonPrefixes;
    }

    @Override
    public String[] getImportedExtensions() {
        if (this.importedExtensions == null) {
            ArrayList<String> l = new ArrayList<String>();
            int i = 0;
            while (i < this.getExtensions().length) {
                ImportDeclaration anImport = this.getExtensions()[i];
                l.add(anImport.getImportString().getValue());
                ++i;
            }
            this.importedExtensions = l.toArray(new String[l.size()]);
        }
        return this.importedExtensions;
    }

    @Override
    public XpandAdvice[] getAdvices() {
        return this.advices;
    }
}

