/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.contentassist.ISubjectControlContextInformationPresenter;
import org.eclipse.jface.contentassist.ISubjectControlContextInformationValidator;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.ui.internal.IReleasable;

class CompoundContentAssistProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private final Set fProcessors = new LinkedHashSet();

    public CompoundContentAssistProcessor() {
    }

    public CompoundContentAssistProcessor(IContentAssistProcessor processor) {
        this.add(processor);
    }

    public void add(IContentAssistProcessor processor) {
        Assert.isNotNull((Object)processor);
        this.fProcessors.add(processor);
    }

    public void remove(IContentAssistProcessor processor) {
        this.fProcessors.remove(processor);
    }

    public CompoundContentAssistProcessor(IContentAssistProcessor[] processors) {
        int i = 0;
        while (i < processors.length) {
            this.add(processors[i]);
            ++i;
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        LinkedList<ICompletionProposal> ret = new LinkedList<ICompletionProposal>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            ICompletionProposal[] proposals = p.computeCompletionProposals(viewer, documentOffset);
            if (proposals == null) continue;
            ret.addAll(Arrays.asList(proposals));
        }
        return ret.toArray(new ICompletionProposal[ret.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        LinkedList<WrappedContextInformation> ret = new LinkedList<WrappedContextInformation>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            IContextInformation[] informations = p.computeContextInformation(viewer, documentOffset);
            if (informations == null) continue;
            int i = 0;
            while (i < informations.length) {
                ret.add(new WrappedContextInformation(informations[i], p));
                ++i;
            }
        }
        return ret.toArray(new IContextInformation[ret.size()]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        LinkedHashSet<Character> ret = new LinkedHashSet<Character>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            char[] chars = p.getCompletionProposalAutoActivationCharacters();
            if (chars == null) continue;
            int i = 0;
            while (i < chars.length) {
                ret.add(new Character(chars[i]));
                ++i;
            }
        }
        char[] chars = new char[ret.size()];
        int i = 0;
        Iterator it2 = ret.iterator();
        while (it2.hasNext()) {
            Character ch = (Character)it2.next();
            chars[i] = ch.charValue();
            ++i;
        }
        return chars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        LinkedHashSet<Character> ret = new LinkedHashSet<Character>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            char[] chars = p.getContextInformationAutoActivationCharacters();
            if (chars == null) continue;
            int i = 0;
            while (i < chars.length) {
                ret.add(new Character(chars[i]));
                ++i;
            }
        }
        char[] chars = new char[ret.size()];
        int i = 0;
        Iterator it2 = ret.iterator();
        while (it2.hasNext()) {
            Character ch = (Character)it2.next();
            chars[i] = ch.charValue();
            ++i;
        }
        return chars;
    }

    public String getErrorMessage() {
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            String err = p.getErrorMessage();
            if (err == null) continue;
            return err;
        }
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        boolean hasValidator = false;
        boolean hasPresenter = false;
        boolean hasExtension = false;
        Iterator itp = this.fProcessors.iterator();
        while (!(!itp.hasNext() || hasPresenter && hasExtension)) {
            IContentAssistProcessor p = (IContentAssistProcessor)itp.next();
            IContextInformationValidator v = p.getContextInformationValidator();
            if (v == null) continue;
            hasValidator = true;
            if (v instanceof IContextInformationPresenter) {
                hasPresenter = true;
            }
            if (!(v instanceof ISubjectControlContextInformationPresenter) && !(v instanceof ISubjectControlContextInformationValidator)) continue;
            hasExtension = true;
        }
        CompoundContentAssistValidator validator = null;
        if (hasPresenter && hasExtension) {
            validator = new CompoundContentAssistValidatorPresenterEx();
        } else if (hasPresenter) {
            validator = new CompoundContentAssistValidatorPresenter(null, null);
        } else if (hasExtension) {
            validator = new CompoundContentAssistValidatorEx();
        } else if (hasValidator) {
            validator = new CompoundContentAssistValidator(null, null);
        }
        if (validator != null) {
            Iterator it = this.fProcessors.iterator();
            while (it.hasNext()) {
                IContentAssistProcessor p = (IContentAssistProcessor)it.next();
                IContextInformationValidator v = p.getContextInformationValidator();
                if (v == null) continue;
                validator.add(v);
            }
        }
        return validator;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        LinkedList<ICompletionProposal> ret = new LinkedList<ICompletionProposal>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            ISubjectControlContentAssistProcessor p;
            ICompletionProposal[] proposals;
            Object o = it.next();
            if (!(o instanceof ISubjectControlContentAssistProcessor) || (proposals = (p = (ISubjectControlContentAssistProcessor)o).computeCompletionProposals(contentAssistSubjectControl, documentOffset)) == null) continue;
            ret.addAll(Arrays.asList(proposals));
        }
        return ret.toArray(new ICompletionProposal[ret.size()]);
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        LinkedList<WrappedContextInformation> ret = new LinkedList<WrappedContextInformation>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            ISubjectControlContentAssistProcessor p;
            IContextInformation[] informations;
            Object o = it.next();
            if (!(o instanceof ISubjectControlContentAssistProcessor) || (informations = (p = (ISubjectControlContentAssistProcessor)o).computeContextInformation(contentAssistSubjectControl, documentOffset)) == null) continue;
            int i = 0;
            while (i < informations.length) {
                ret.add(new WrappedContextInformation(informations[i], (IContentAssistProcessor)p));
                ++i;
            }
        }
        return ret.toArray(new IContextInformation[ret.size()]);
    }

    public void dispose() {
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            if (!(p instanceof IReleasable)) continue;
            ((IReleasable)p).release();
        }
        this.fProcessors.clear();
    }

    private static class CompoundContentAssistValidator
    implements IContextInformationValidator {
        List fValidators = new ArrayList();
        IContextInformationValidator fValidator;

        private CompoundContentAssistValidator() {
        }

        void add(IContextInformationValidator validator) {
            this.fValidators.add(validator);
        }

        public void install(IContextInformation info, ITextViewer viewer, int documentPosition) {
            this.fValidator = this.getValidator(info);
            IContextInformation realInfo = this.getContextInformation(info);
            if (this.fValidator != null) {
                this.fValidator.install(realInfo, viewer, documentPosition);
            } else {
                Iterator it = this.fValidators.iterator();
                while (it.hasNext()) {
                    IContextInformationValidator v = (IContextInformationValidator)it.next();
                    v.install(realInfo, viewer, documentPosition);
                }
            }
        }

        IContextInformationValidator getValidator(IContextInformation info) {
            if (info instanceof WrappedContextInformation) {
                WrappedContextInformation wrap = (WrappedContextInformation)info;
                return wrap.getProcessor().getContextInformationValidator();
            }
            return null;
        }

        IContextInformation getContextInformation(IContextInformation info) {
            IContextInformation realInfo = info;
            if (info instanceof WrappedContextInformation) {
                WrappedContextInformation wrap = (WrappedContextInformation)info;
                realInfo = wrap.getContextInformation();
            }
            return realInfo;
        }

        public boolean isContextInformationValid(int documentPosition) {
            boolean isValid = false;
            if (this.fValidator != null) {
                isValid = this.fValidator.isContextInformationValid(documentPosition);
            } else {
                Iterator it = this.fValidators.iterator();
                while (it.hasNext()) {
                    IContextInformationValidator v = (IContextInformationValidator)it.next();
                    isValid |= v.isContextInformationValid(documentPosition);
                }
            }
            return isValid;
        }

        /* synthetic */ CompoundContentAssistValidator(CompoundContentAssistValidator compoundContentAssistValidator, CompoundContentAssistValidator compoundContentAssistValidator2) {
            this();
        }
    }

    private static class CompoundContentAssistValidatorEx
    extends CompoundContentAssistValidator
    implements ISubjectControlContextInformationValidator {
        private CompoundContentAssistValidatorEx() {
        }

        public void install(IContextInformation info, IContentAssistSubjectControl contentAssistSubjectControl, int documentPosition) {
            this.fValidator = this.getValidator(info);
            IContextInformation realInfo = this.getContextInformation(info);
            if (this.fValidator instanceof ISubjectControlContextInformationValidator) {
                ((ISubjectControlContextInformationValidator)this.fValidator).install(realInfo, contentAssistSubjectControl, documentPosition);
            } else {
                Iterator it = this.fValidators.iterator();
                while (it.hasNext()) {
                    if (!(it.next() instanceof ISubjectControlContextInformationValidator)) continue;
                    ((ISubjectControlContextInformationValidator)it.next()).install(realInfo, contentAssistSubjectControl, documentPosition);
                }
            }
        }
    }

    private static class CompoundContentAssistValidatorPresenter
    extends CompoundContentAssistValidator
    implements IContextInformationPresenter {
        private CompoundContentAssistValidatorPresenter() {
        }

        public boolean updatePresentation(int offset, TextPresentation presentation) {
            boolean presentationUpdated = false;
            if (this.fValidator instanceof IContextInformationPresenter) {
                presentationUpdated = ((IContextInformationPresenter)this.fValidator).updatePresentation(offset, presentation);
            } else {
                Iterator it = this.fValidators.iterator();
                while (it.hasNext()) {
                    IContextInformationValidator v = (IContextInformationValidator)it.next();
                    if (!(v instanceof IContextInformationPresenter)) continue;
                    presentationUpdated |= ((IContextInformationPresenter)v).updatePresentation(offset, presentation);
                }
            }
            return presentationUpdated;
        }

        /* synthetic */ CompoundContentAssistValidatorPresenter(CompoundContentAssistValidatorPresenter compoundContentAssistValidatorPresenter, CompoundContentAssistValidatorPresenter compoundContentAssistValidatorPresenter2) {
            this();
        }
    }

    private static class CompoundContentAssistValidatorPresenterEx
    extends CompoundContentAssistValidatorPresenter
    implements ISubjectControlContextInformationPresenter,
    ISubjectControlContextInformationValidator {
        private CompoundContentAssistValidatorPresenterEx() {
        }

        public void install(IContextInformation info, IContentAssistSubjectControl contentAssistSubjectControl, int documentPosition) {
            this.fValidator = this.getValidator(info);
            IContextInformation realInfo = this.getContextInformation(info);
            if (this.fValidator instanceof ISubjectControlContextInformationValidator) {
                ((ISubjectControlContextInformationValidator)this.fValidator).install(realInfo, contentAssistSubjectControl, documentPosition);
            } else {
                Iterator it = this.fValidators.iterator();
                while (it.hasNext()) {
                    if (!(it.next() instanceof ISubjectControlContextInformationValidator)) continue;
                    ((ISubjectControlContextInformationValidator)it.next()).install(realInfo, contentAssistSubjectControl, documentPosition);
                }
            }
        }
    }

    private static class WrappedContextInformation
    implements IContextInformation {
        private IContextInformation fInfo;
        private IContentAssistProcessor fProcessor;

        WrappedContextInformation(IContextInformation info, IContentAssistProcessor processor) {
            this.fInfo = info;
            this.fProcessor = processor;
        }

        public boolean equals(Object obj) {
            return this.fInfo.equals(obj);
        }

        public String getContextDisplayString() {
            return this.fInfo.getContextDisplayString();
        }

        public Image getImage() {
            return this.fInfo.getImage();
        }

        public String getInformationDisplayString() {
            return this.fInfo.getInformationDisplayString();
        }

        public int hashCode() {
            return this.fInfo.hashCode();
        }

        public String toString() {
            return this.fInfo.toString();
        }

        IContentAssistProcessor getProcessor() {
            return this.fProcessor;
        }

        IContextInformation getContextInformation() {
            return this.fInfo;
        }
    }
}

