/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.orm;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.OrmPackage;
import org.eclipse.jpt.core.internal.content.orm.XmlDiscriminatorColumn;
import org.eclipse.jpt.core.internal.content.orm.XmlEntity;
import org.eclipse.jpt.core.internal.content.orm.XmlEntityForXml;
import org.eclipse.jpt.core.internal.content.orm.XmlIdClass;
import org.eclipse.jpt.core.internal.content.orm.XmlInheritance;
import org.eclipse.jpt.core.internal.content.orm.XmlTable;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.jdtutility.Type;
import org.eclipse.jpt.core.internal.mappings.IAssociationOverride;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IDiscriminatorColumn;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.INamedNativeQuery;
import org.eclipse.jpt.core.internal.mappings.INamedQuery;
import org.eclipse.jpt.core.internal.mappings.IOverride;
import org.eclipse.jpt.core.internal.mappings.IPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.mappings.ISecondaryTable;
import org.eclipse.jpt.core.internal.mappings.ISequenceGenerator;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.core.internal.mappings.ITableGenerator;
import org.eclipse.jpt.core.internal.mappings.InheritanceType;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEntityInternal
extends XmlTypeMapping
implements XmlEntityForXml,
XmlEntity {
    protected XmlIdClass idClassForXml;
    protected XmlInheritance inheritanceForXml;
    protected static final String SPECIFIED_NAME_EDEFAULT = null;
    protected String specifiedName = SPECIFIED_NAME_EDEFAULT;
    protected static final String DEFAULT_NAME_EDEFAULT = null;
    protected String defaultName = DEFAULT_NAME_EDEFAULT;
    protected ITable table;
    protected EList<ISecondaryTable> specifiedSecondaryTables;
    protected EList<IPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns;
    protected EList<IPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns;
    protected static final InheritanceType INHERITANCE_STRATEGY_EDEFAULT = InheritanceType.DEFAULT;
    protected InheritanceType inheritanceStrategy = INHERITANCE_STRATEGY_EDEFAULT;
    protected static final String DEFAULT_DISCRIMINATOR_VALUE_EDEFAULT = null;
    protected String defaultDiscriminatorValue = DEFAULT_DISCRIMINATOR_VALUE_EDEFAULT;
    protected static final String SPECIFIED_DISCRIMINATOR_VALUE_EDEFAULT = null;
    protected String specifiedDiscriminatorValue = SPECIFIED_DISCRIMINATOR_VALUE_EDEFAULT;
    protected static final String DISCRIMINATOR_VALUE_EDEFAULT = null;
    protected IDiscriminatorColumn discriminatorColumn;
    protected ISequenceGenerator sequenceGenerator;
    protected ITableGenerator tableGenerator;
    protected EList<IAttributeOverride> specifiedAttributeOverrides;
    protected EList<IAttributeOverride> defaultAttributeOverrides;
    protected EList<IAssociationOverride> specifiedAssociationOverrides;
    protected EList<IAssociationOverride> defaultAssociationOverrides;
    protected EList<INamedQuery> namedQueries;
    protected EList<INamedNativeQuery> namedNativeQueries;
    protected static final String ID_CLASS_EDEFAULT = null;
    protected String idClass = ID_CLASS_EDEFAULT;
    protected EList<ISecondaryTable> virtualSecondaryTables;

    protected XmlEntityInternal() {
        this.table = OrmFactory.eINSTANCE.createXmlTable(this.buildTableOwner());
        ((InternalEObject)this.table).eInverseAdd((InternalEObject)this, -14, null, null);
        this.discriminatorColumn = OrmFactory.eINSTANCE.createXmlDiscriminatorColumn(new IDiscriminatorColumn.Owner(this));
        ((InternalEObject)this.discriminatorColumn).eInverseAdd((InternalEObject)this, -23, null, null);
        this.getDefaultPrimaryKeyJoinColumns().add((Object)this.createPrimaryKeyJoinColumn(0));
        this.eAdapters().add((Object)this.buildListener());
    }

    protected Adapter buildListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                XmlEntityInternal.this.notifyChanged(notification);
            }
        };
    }

    protected void notifyChanged(Notification notification) {
        switch (notification.getFeatureID(IEntity.class)) {
            case 24: {
                this.idClassChanged();
                break;
            }
            case 9: {
                this.inheritanceStrategyChanged();
                break;
            }
        }
        switch (notification.getFeatureID(XmlEntityForXml.class)) {
            case 2: {
                this.xmlIdClassChanged();
                break;
            }
            case 3: {
                this.xmlInheritanceChanged();
                break;
            }
        }
    }

    protected void inheritanceStrategyChanged() {
        if (this.getInheritanceStrategy() == InheritanceType.DEFAULT) {
            this.setInheritanceForXml(null);
        } else {
            if (this.getInheritanceForXml() == null) {
                this.setInheritanceForXml(OrmFactory.eINSTANCE.createXmlInheritance());
            }
            this.getInheritanceForXml().setStrategy(this.getInheritanceStrategy());
        }
    }

    protected void xmlInheritanceChanged() {
        if (this.getInheritanceForXml() == null) {
            this.setInheritanceStrategy(null);
        }
    }

    @Override
    protected void addInsignificantFeatureIdsTo(Set<Integer> insignificantFeatureIds) {
        super.addInsignificantFeatureIdsTo(insignificantFeatureIds);
        insignificantFeatureIds.add(34);
        insignificantFeatureIds.add(25);
        insignificantFeatureIds.add(28);
    }

    private ITable.Owner buildTableOwner() {
        return new ITable.Owner(){

            public ITextRange validationTextRange() {
                return XmlEntityInternal.this.validationTextRange();
            }

            public ITypeMapping getTypeMapping() {
                return XmlEntityInternal.this;
            }
        };
    }

    @Override
    protected EClass eStaticClass() {
        return OrmPackage.Literals.XML_ENTITY_INTERNAL;
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldSpecifiedName, (Object)this.specifiedName));
        }
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    public ITable getTable() {
        return this.table;
    }

    private XmlTable getTableInternal() {
        return (XmlTable)this.getTable();
    }

    public NotificationChain basicSetTable(ITable newTable, NotificationChain msgs) {
        ITable oldTable = this.table;
        this.table = newTable;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldTable, (Object)newTable);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public EList<ISecondaryTable> getSecondaryTables() {
        EObjectEList list = new EObjectEList(ISecondaryTable.class, (InternalEObject)this, 34);
        list.addAll(this.getSpecifiedSecondaryTables());
        list.addAll(this.getVirtualSecondaryTables());
        return list;
    }

    @Override
    public EList<ISecondaryTable> getVirtualSecondaryTables() {
        if (this.virtualSecondaryTables == null) {
            this.virtualSecondaryTables = new EObjectContainmentEList(ISecondaryTable.class, (InternalEObject)this, 35);
        }
        return this.virtualSecondaryTables;
    }

    protected void xmlIdClassChanged() {
        if (this.getIdClassForXml() == null) {
            this.setIdClass(null);
        }
    }

    @Override
    public boolean containsSecondaryTable(String name) {
        return this.containsSecondaryTable(name, (List<ISecondaryTable>)this.getSecondaryTables());
    }

    @Override
    public boolean containsSpecifiedSecondaryTable(String name) {
        return this.containsSecondaryTable(name, (List<ISecondaryTable>)this.getSpecifiedSecondaryTables());
    }

    private boolean containsSecondaryTable(String name, List<ISecondaryTable> secondaryTables) {
        for (ISecondaryTable secondaryTable : secondaryTables) {
            String secondaryTableName = secondaryTable.getName();
            if (secondaryTableName == null || !secondaryTableName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EList<ISecondaryTable> getSpecifiedSecondaryTables() {
        if (this.specifiedSecondaryTables == null) {
            this.specifiedSecondaryTables = new EObjectContainmentEList(ISecondaryTable.class, (InternalEObject)this, 14);
        }
        return this.specifiedSecondaryTables;
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.inheritanceStrategy;
    }

    @Override
    public void setInheritanceStrategy(InheritanceType newInheritanceStrategy) {
        InheritanceType oldInheritanceStrategy = this.inheritanceStrategy;
        InheritanceType inheritanceType = this.inheritanceStrategy = newInheritanceStrategy == null ? INHERITANCE_STRATEGY_EDEFAULT : newInheritanceStrategy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldInheritanceStrategy, (Object)this.inheritanceStrategy));
        }
    }

    @Override
    public IDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public NotificationChain basicSetDiscriminatorColumn(IDiscriminatorColumn newDiscriminatorColumn, NotificationChain msgs) {
        IDiscriminatorColumn oldDiscriminatorColumn = this.discriminatorColumn;
        this.discriminatorColumn = newDiscriminatorColumn;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 22, (Object)oldDiscriminatorColumn, (Object)newDiscriminatorColumn);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public ISequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public NotificationChain basicSetSequenceGenerator(ISequenceGenerator newSequenceGenerator, NotificationChain msgs) {
        ISequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldSequenceGenerator, (Object)newSequenceGenerator);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setSequenceGenerator(ISequenceGenerator newSequenceGenerator) {
        if (newSequenceGenerator != this.sequenceGenerator) {
            NotificationChain msgs = null;
            if (this.sequenceGenerator != null) {
                msgs = ((InternalEObject)this.sequenceGenerator).eInverseRemove((InternalEObject)this, -24, null, msgs);
            }
            if (newSequenceGenerator != null) {
                msgs = ((InternalEObject)newSequenceGenerator).eInverseAdd((InternalEObject)this, -24, null, msgs);
            }
            if ((msgs = this.basicSetSequenceGenerator(newSequenceGenerator, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)newSequenceGenerator, (Object)newSequenceGenerator));
        }
    }

    @Override
    public ITableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    public NotificationChain basicSetTableGenerator(ITableGenerator newTableGenerator, NotificationChain msgs) {
        ITableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 24, (Object)oldTableGenerator, (Object)newTableGenerator);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setTableGenerator(ITableGenerator newTableGenerator) {
        if (newTableGenerator != this.tableGenerator) {
            NotificationChain msgs = null;
            if (this.tableGenerator != null) {
                msgs = ((InternalEObject)this.tableGenerator).eInverseRemove((InternalEObject)this, -25, null, msgs);
            }
            if (newTableGenerator != null) {
                msgs = ((InternalEObject)newTableGenerator).eInverseAdd((InternalEObject)this, -25, null, msgs);
            }
            if ((msgs = this.basicSetTableGenerator(newTableGenerator, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, (Object)newTableGenerator, (Object)newTableGenerator));
        }
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    @Override
    public void setDefaultDiscriminatorValue(String newDefaultDiscriminatorValue) {
        String oldDefaultDiscriminatorValue = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = newDefaultDiscriminatorValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, (Object)oldDefaultDiscriminatorValue, (Object)this.defaultDiscriminatorValue));
        }
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String newSpecifiedDiscriminatorValue) {
        String oldSpecifiedDiscriminatorValue = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = newSpecifiedDiscriminatorValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldSpecifiedDiscriminatorValue, (Object)this.specifiedDiscriminatorValue));
        }
    }

    @Override
    public String getDiscriminatorValue() {
        return this.getSpecifiedDiscriminatorValue() == null ? this.getDefaultDiscriminatorValue() : this.getSpecifiedDiscriminatorValue();
    }

    @Override
    public EList<IPrimaryKeyJoinColumn> getPrimaryKeyJoinColumns() {
        return this.getSpecifiedPrimaryKeyJoinColumns().isEmpty() ? this.getDefaultPrimaryKeyJoinColumns() : this.getSpecifiedPrimaryKeyJoinColumns();
    }

    @Override
    public EList<IPrimaryKeyJoinColumn> getSpecifiedPrimaryKeyJoinColumns() {
        if (this.specifiedPrimaryKeyJoinColumns == null) {
            this.specifiedPrimaryKeyJoinColumns = new EObjectContainmentEList(IPrimaryKeyJoinColumn.class, (InternalEObject)this, 16);
        }
        return this.specifiedPrimaryKeyJoinColumns;
    }

    @Override
    public EList<IPrimaryKeyJoinColumn> getDefaultPrimaryKeyJoinColumns() {
        if (this.defaultPrimaryKeyJoinColumns == null) {
            this.defaultPrimaryKeyJoinColumns = new EObjectContainmentEList(IPrimaryKeyJoinColumn.class, (InternalEObject)this, 17);
        }
        return this.defaultPrimaryKeyJoinColumns;
    }

    @Override
    public EList<IAttributeOverride> getAttributeOverrides() {
        EObjectEList list = new EObjectEList(IAttributeOverride.class, (InternalEObject)this, 25);
        list.addAll(this.getSpecifiedAttributeOverrides());
        list.addAll(this.getDefaultAttributeOverrides());
        return list;
    }

    @Override
    public EList<IAttributeOverride> getSpecifiedAttributeOverrides() {
        if (this.specifiedAttributeOverrides == null) {
            this.specifiedAttributeOverrides = new EObjectContainmentEList(IAttributeOverride.class, (InternalEObject)this, 26);
        }
        return this.specifiedAttributeOverrides;
    }

    @Override
    public EList<IAttributeOverride> getDefaultAttributeOverrides() {
        if (this.defaultAttributeOverrides == null) {
            this.defaultAttributeOverrides = new EObjectContainmentEList(IAttributeOverride.class, (InternalEObject)this, 27);
        }
        return this.defaultAttributeOverrides;
    }

    @Override
    public EList<IAssociationOverride> getAssociationOverrides() {
        EObjectEList list = new EObjectEList(IAssociationOverride.class, (InternalEObject)this, 28);
        list.addAll(this.getSpecifiedAssociationOverrides());
        list.addAll(this.getDefaultAssociationOverrides());
        return list;
    }

    @Override
    public EList<IAssociationOverride> getSpecifiedAssociationOverrides() {
        if (this.specifiedAssociationOverrides == null) {
            this.specifiedAssociationOverrides = new EObjectContainmentEList(IAssociationOverride.class, (InternalEObject)this, 29);
        }
        return this.specifiedAssociationOverrides;
    }

    @Override
    public EList<IAssociationOverride> getDefaultAssociationOverrides() {
        if (this.defaultAssociationOverrides == null) {
            this.defaultAssociationOverrides = new EObjectContainmentEList(IAssociationOverride.class, (InternalEObject)this, 30);
        }
        return this.defaultAssociationOverrides;
    }

    @Override
    public EList<INamedQuery> getNamedQueries() {
        if (this.namedQueries == null) {
            this.namedQueries = new EObjectContainmentEList(INamedQuery.class, (InternalEObject)this, 31);
        }
        return this.namedQueries;
    }

    @Override
    public EList<INamedNativeQuery> getNamedNativeQueries() {
        if (this.namedNativeQueries == null) {
            this.namedNativeQueries = new EObjectContainmentEList(INamedNativeQuery.class, (InternalEObject)this, 32);
        }
        return this.namedNativeQueries;
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public void setIdClass(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 33, (Object)oldIdClass, (Object)this.idClass));
        }
    }

    protected void idClassChanged() {
        if (this.getIdClass() == null) {
            this.setIdClassForXml(null);
        } else {
            if (this.getIdClassForXml() == null) {
                this.setIdClassForXml(OrmFactory.eINSTANCE.createXmlIdClass());
            }
            this.getIdClassForXml().setValue(this.getIdClass());
        }
    }

    @Override
    public boolean discriminatorValueIsAllowed() {
        Type type = this.getPersistentType().findType();
        return type == null ? false : !type.isAbstract();
    }

    @Override
    public IEntity parentEntity() {
        Iterator<IPersistentType> i = this.getPersistentType().inheritanceHierarchy();
        while (i.hasNext()) {
            ITypeMapping typeMapping = i.next().getMapping();
            if (typeMapping == this || !(typeMapping instanceof IEntity)) continue;
            return (IEntity)typeMapping;
        }
        return this;
    }

    @Override
    public IEntity rootEntity() {
        IEntity rootEntity = null;
        Iterator<IPersistentType> i = this.getPersistentType().inheritanceHierarchy();
        while (i.hasNext()) {
            IPersistentType persistentType = i.next();
            if (!(persistentType.getMapping() instanceof IEntity)) continue;
            rootEntity = (IEntity)persistentType.getMapping();
        }
        return rootEntity;
    }

    @Override
    public XmlTable getTableForXml() {
        if (this.getTableInternal().isAllFeaturesUnset()) {
            return null;
        }
        return this.getTableInternal();
    }

    public void setTableForXmlGen(XmlTable newTableForXml) {
        XmlTable oldValue;
        XmlTable xmlTable = oldValue = newTableForXml == null ? (XmlTable)this.getTable() : null;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldValue, (Object)newTableForXml));
        }
    }

    @Override
    public void setTableForXml(XmlTable newTableForXml) {
        this.setTableForXmlGen(newTableForXml);
        if (newTableForXml == null) {
            this.getTableInternal().unsetAllAttributes();
        }
    }

    @Override
    public XmlDiscriminatorColumn getDiscriminatorColumnForXml() {
        if (this.getDiscriminatorColumnInternal().isAllFeaturesUnset()) {
            return null;
        }
        return this.getDiscriminatorColumnInternal();
    }

    private XmlDiscriminatorColumn getDiscriminatorColumnInternal() {
        return (XmlDiscriminatorColumn)this.getDiscriminatorColumn();
    }

    public void setDiscriminatorColumnForXmlGen(XmlDiscriminatorColumn newDiscriminatorColumnForXml) {
        XmlDiscriminatorColumn oldValue;
        XmlDiscriminatorColumn xmlDiscriminatorColumn = oldValue = newDiscriminatorColumnForXml == null ? (XmlDiscriminatorColumn)this.getDiscriminatorColumn() : null;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldValue, (Object)newDiscriminatorColumnForXml));
        }
    }

    @Override
    public void setDiscriminatorColumnForXml(XmlDiscriminatorColumn newDiscriminatorColumnForXml) {
        this.setDiscriminatorColumnForXmlGen(newDiscriminatorColumnForXml);
        if (newDiscriminatorColumnForXml == null) {
            this.getDiscriminatorColumnInternal().unsetAllAttributes();
            Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)this.getDiscriminatorColumnInternal(), (Object)EMF2DOMAdapter.ADAPTER_CLASS);
            this.getDiscriminatorColumnInternal().eAdapters().remove((Object)adapter);
        }
    }

    @Override
    public XmlIdClass getIdClassForXml() {
        return this.idClassForXml;
    }

    public NotificationChain basicSetIdClassForXml(XmlIdClass newIdClassForXml, NotificationChain msgs) {
        XmlIdClass oldIdClassForXml = this.idClassForXml;
        this.idClassForXml = newIdClassForXml;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldIdClassForXml, (Object)newIdClassForXml);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setIdClassForXml(XmlIdClass newIdClassForXml) {
        if (newIdClassForXml != this.idClassForXml) {
            NotificationChain msgs = null;
            if (this.idClassForXml != null) {
                msgs = this.idClassForXml.eInverseRemove((InternalEObject)this, -10, null, msgs);
            }
            if (newIdClassForXml != null) {
                msgs = newIdClassForXml.eInverseAdd((InternalEObject)this, -10, null, msgs);
            }
            if ((msgs = this.basicSetIdClassForXml(newIdClassForXml, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)newIdClassForXml, (Object)newIdClassForXml));
        }
    }

    @Override
    public XmlInheritance getInheritanceForXml() {
        return this.inheritanceForXml;
    }

    public NotificationChain basicSetInheritanceForXml(XmlInheritance newInheritanceForXml, NotificationChain msgs) {
        XmlInheritance oldInheritanceForXml = this.inheritanceForXml;
        this.inheritanceForXml = newInheritanceForXml;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldInheritanceForXml, (Object)newInheritanceForXml);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setInheritanceForXml(XmlInheritance newInheritanceForXml) {
        if (newInheritanceForXml != this.inheritanceForXml) {
            NotificationChain msgs = null;
            if (this.inheritanceForXml != null) {
                msgs = this.inheritanceForXml.eInverseRemove((InternalEObject)this, -11, null, msgs);
            }
            if (newInheritanceForXml != null) {
                msgs = newInheritanceForXml.eInverseAdd((InternalEObject)this, -11, null, msgs);
            }
            if ((msgs = this.basicSetInheritanceForXml(newInheritanceForXml, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)newInheritanceForXml, (Object)newInheritanceForXml));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return this.basicSetIdClassForXml(null, msgs);
            }
            case 10: {
                return this.basicSetInheritanceForXml(null, msgs);
            }
            case 13: {
                return this.basicSetTable(null, msgs);
            }
            case 14: {
                return ((InternalEList)this.getSpecifiedSecondaryTables()).basicRemove((Object)otherEnd, msgs);
            }
            case 15: {
                return ((InternalEList)this.getPrimaryKeyJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 16: {
                return ((InternalEList)this.getSpecifiedPrimaryKeyJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 17: {
                return ((InternalEList)this.getDefaultPrimaryKeyJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 22: {
                return this.basicSetDiscriminatorColumn(null, msgs);
            }
            case 23: {
                return this.basicSetSequenceGenerator(null, msgs);
            }
            case 24: {
                return this.basicSetTableGenerator(null, msgs);
            }
            case 25: {
                return ((InternalEList)this.getAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
            }
            case 26: {
                return ((InternalEList)this.getSpecifiedAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
            }
            case 27: {
                return ((InternalEList)this.getDefaultAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
            }
            case 28: {
                return ((InternalEList)this.getAssociationOverrides()).basicRemove((Object)otherEnd, msgs);
            }
            case 29: {
                return ((InternalEList)this.getSpecifiedAssociationOverrides()).basicRemove((Object)otherEnd, msgs);
            }
            case 30: {
                return ((InternalEList)this.getDefaultAssociationOverrides()).basicRemove((Object)otherEnd, msgs);
            }
            case 31: {
                return ((InternalEList)this.getNamedQueries()).basicRemove((Object)otherEnd, msgs);
            }
            case 32: {
                return ((InternalEList)this.getNamedNativeQueries()).basicRemove((Object)otherEnd, msgs);
            }
            case 34: {
                return ((InternalEList)this.getSecondaryTables()).basicRemove((Object)otherEnd, msgs);
            }
            case 35: {
                return ((InternalEList)this.getVirtualSecondaryTables()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldDefaultName, (Object)this.defaultName));
        }
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
        this.setDefaultName((String)defaultsContext.getDefault("entity.name"));
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getTableForXml();
            }
            case 8: {
                return this.getDiscriminatorColumnForXml();
            }
            case 9: {
                return this.getIdClassForXml();
            }
            case 10: {
                return this.getInheritanceForXml();
            }
            case 11: {
                return this.getSpecifiedName();
            }
            case 12: {
                return this.getDefaultName();
            }
            case 13: {
                return this.getTable();
            }
            case 14: {
                return this.getSpecifiedSecondaryTables();
            }
            case 15: {
                return this.getPrimaryKeyJoinColumns();
            }
            case 16: {
                return this.getSpecifiedPrimaryKeyJoinColumns();
            }
            case 17: {
                return this.getDefaultPrimaryKeyJoinColumns();
            }
            case 18: {
                return this.getInheritanceStrategy();
            }
            case 19: {
                return this.getDefaultDiscriminatorValue();
            }
            case 20: {
                return this.getSpecifiedDiscriminatorValue();
            }
            case 21: {
                return this.getDiscriminatorValue();
            }
            case 22: {
                return this.getDiscriminatorColumn();
            }
            case 23: {
                return this.getSequenceGenerator();
            }
            case 24: {
                return this.getTableGenerator();
            }
            case 25: {
                return this.getAttributeOverrides();
            }
            case 26: {
                return this.getSpecifiedAttributeOverrides();
            }
            case 27: {
                return this.getDefaultAttributeOverrides();
            }
            case 28: {
                return this.getAssociationOverrides();
            }
            case 29: {
                return this.getSpecifiedAssociationOverrides();
            }
            case 30: {
                return this.getDefaultAssociationOverrides();
            }
            case 31: {
                return this.getNamedQueries();
            }
            case 32: {
                return this.getNamedNativeQueries();
            }
            case 33: {
                return this.getIdClass();
            }
            case 34: {
                return this.getSecondaryTables();
            }
            case 35: {
                return this.getVirtualSecondaryTables();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setTableForXml((XmlTable)newValue);
                return;
            }
            case 8: {
                this.setDiscriminatorColumnForXml((XmlDiscriminatorColumn)newValue);
                return;
            }
            case 9: {
                this.setIdClassForXml((XmlIdClass)newValue);
                return;
            }
            case 10: {
                this.setInheritanceForXml((XmlInheritance)newValue);
                return;
            }
            case 11: {
                this.setSpecifiedName((String)newValue);
                return;
            }
            case 14: {
                this.getSpecifiedSecondaryTables().clear();
                this.getSpecifiedSecondaryTables().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.getSpecifiedPrimaryKeyJoinColumns().clear();
                this.getSpecifiedPrimaryKeyJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getDefaultPrimaryKeyJoinColumns().clear();
                this.getDefaultPrimaryKeyJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.setInheritanceStrategy((InheritanceType)((Object)newValue));
                return;
            }
            case 19: {
                this.setDefaultDiscriminatorValue((String)newValue);
                return;
            }
            case 20: {
                this.setSpecifiedDiscriminatorValue((String)newValue);
                return;
            }
            case 23: {
                this.setSequenceGenerator((ISequenceGenerator)newValue);
                return;
            }
            case 24: {
                this.setTableGenerator((ITableGenerator)newValue);
                return;
            }
            case 26: {
                this.getSpecifiedAttributeOverrides().clear();
                this.getSpecifiedAttributeOverrides().addAll((Collection)newValue);
                return;
            }
            case 27: {
                this.getDefaultAttributeOverrides().clear();
                this.getDefaultAttributeOverrides().addAll((Collection)newValue);
                return;
            }
            case 29: {
                this.getSpecifiedAssociationOverrides().clear();
                this.getSpecifiedAssociationOverrides().addAll((Collection)newValue);
                return;
            }
            case 30: {
                this.getDefaultAssociationOverrides().clear();
                this.getDefaultAssociationOverrides().addAll((Collection)newValue);
                return;
            }
            case 31: {
                this.getNamedQueries().clear();
                this.getNamedQueries().addAll((Collection)newValue);
                return;
            }
            case 32: {
                this.getNamedNativeQueries().clear();
                this.getNamedNativeQueries().addAll((Collection)newValue);
                return;
            }
            case 33: {
                this.setIdClass((String)newValue);
                return;
            }
            case 35: {
                this.getVirtualSecondaryTables().clear();
                this.getVirtualSecondaryTables().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setTableForXml(null);
                return;
            }
            case 8: {
                this.setDiscriminatorColumnForXml(null);
                return;
            }
            case 9: {
                this.setIdClassForXml(null);
                return;
            }
            case 10: {
                this.setInheritanceForXml(null);
                return;
            }
            case 11: {
                this.setSpecifiedName(SPECIFIED_NAME_EDEFAULT);
                return;
            }
            case 14: {
                this.getSpecifiedSecondaryTables().clear();
                return;
            }
            case 16: {
                this.getSpecifiedPrimaryKeyJoinColumns().clear();
                return;
            }
            case 17: {
                this.getDefaultPrimaryKeyJoinColumns().clear();
                return;
            }
            case 18: {
                this.setInheritanceStrategy(INHERITANCE_STRATEGY_EDEFAULT);
                return;
            }
            case 19: {
                this.setDefaultDiscriminatorValue(DEFAULT_DISCRIMINATOR_VALUE_EDEFAULT);
                return;
            }
            case 20: {
                this.setSpecifiedDiscriminatorValue(SPECIFIED_DISCRIMINATOR_VALUE_EDEFAULT);
                return;
            }
            case 23: {
                this.setSequenceGenerator(null);
                return;
            }
            case 24: {
                this.setTableGenerator(null);
                return;
            }
            case 26: {
                this.getSpecifiedAttributeOverrides().clear();
                return;
            }
            case 27: {
                this.getDefaultAttributeOverrides().clear();
                return;
            }
            case 29: {
                this.getSpecifiedAssociationOverrides().clear();
                return;
            }
            case 30: {
                this.getDefaultAssociationOverrides().clear();
                return;
            }
            case 31: {
                this.getNamedQueries().clear();
                return;
            }
            case 32: {
                this.getNamedNativeQueries().clear();
                return;
            }
            case 33: {
                this.setIdClass(ID_CLASS_EDEFAULT);
                return;
            }
            case 35: {
                this.getVirtualSecondaryTables().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return this.getTableForXml() != null;
            }
            case 8: {
                return this.getDiscriminatorColumnForXml() != null;
            }
            case 9: {
                return this.idClassForXml != null;
            }
            case 10: {
                return this.inheritanceForXml != null;
            }
            case 11: {
                return SPECIFIED_NAME_EDEFAULT == null ? this.specifiedName != null : !SPECIFIED_NAME_EDEFAULT.equals(this.specifiedName);
            }
            case 12: {
                return DEFAULT_NAME_EDEFAULT == null ? this.defaultName != null : !DEFAULT_NAME_EDEFAULT.equals(this.defaultName);
            }
            case 13: {
                return this.table != null;
            }
            case 14: {
                return this.specifiedSecondaryTables != null && !this.specifiedSecondaryTables.isEmpty();
            }
            case 15: {
                return !this.getPrimaryKeyJoinColumns().isEmpty();
            }
            case 16: {
                return this.specifiedPrimaryKeyJoinColumns != null && !this.specifiedPrimaryKeyJoinColumns.isEmpty();
            }
            case 17: {
                return this.defaultPrimaryKeyJoinColumns != null && !this.defaultPrimaryKeyJoinColumns.isEmpty();
            }
            case 18: {
                return this.inheritanceStrategy != INHERITANCE_STRATEGY_EDEFAULT;
            }
            case 19: {
                return DEFAULT_DISCRIMINATOR_VALUE_EDEFAULT == null ? this.defaultDiscriminatorValue != null : !DEFAULT_DISCRIMINATOR_VALUE_EDEFAULT.equals(this.defaultDiscriminatorValue);
            }
            case 20: {
                return SPECIFIED_DISCRIMINATOR_VALUE_EDEFAULT == null ? this.specifiedDiscriminatorValue != null : !SPECIFIED_DISCRIMINATOR_VALUE_EDEFAULT.equals(this.specifiedDiscriminatorValue);
            }
            case 21: {
                return DISCRIMINATOR_VALUE_EDEFAULT == null ? this.getDiscriminatorValue() != null : !DISCRIMINATOR_VALUE_EDEFAULT.equals(this.getDiscriminatorValue());
            }
            case 22: {
                return this.discriminatorColumn != null;
            }
            case 23: {
                return this.sequenceGenerator != null;
            }
            case 24: {
                return this.tableGenerator != null;
            }
            case 25: {
                return !this.getAttributeOverrides().isEmpty();
            }
            case 26: {
                return this.specifiedAttributeOverrides != null && !this.specifiedAttributeOverrides.isEmpty();
            }
            case 27: {
                return this.defaultAttributeOverrides != null && !this.defaultAttributeOverrides.isEmpty();
            }
            case 28: {
                return !this.getAssociationOverrides().isEmpty();
            }
            case 29: {
                return this.specifiedAssociationOverrides != null && !this.specifiedAssociationOverrides.isEmpty();
            }
            case 30: {
                return this.defaultAssociationOverrides != null && !this.defaultAssociationOverrides.isEmpty();
            }
            case 31: {
                return this.namedQueries != null && !this.namedQueries.isEmpty();
            }
            case 32: {
                return this.namedNativeQueries != null && !this.namedNativeQueries.isEmpty();
            }
            case 33: {
                return ID_CLASS_EDEFAULT == null ? this.idClass != null : !ID_CLASS_EDEFAULT.equals(this.idClass);
            }
            case 34: {
                return !this.getSecondaryTables().isEmpty();
            }
            case 35: {
                return this.virtualSecondaryTables != null && !this.virtualSecondaryTables.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == XmlEntityForXml.class) {
            switch (derivedFeatureID) {
                case 7: {
                    return 0;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 2;
                }
                case 10: {
                    return 3;
                }
            }
            return -1;
        }
        if (baseClass == IEntity.class) {
            switch (derivedFeatureID) {
                case 11: {
                    return 2;
                }
                case 12: {
                    return 3;
                }
                case 13: {
                    return 4;
                }
                case 14: {
                    return 5;
                }
                case 15: {
                    return 6;
                }
                case 16: {
                    return 7;
                }
                case 17: {
                    return 8;
                }
                case 18: {
                    return 9;
                }
                case 19: {
                    return 10;
                }
                case 20: {
                    return 11;
                }
                case 21: {
                    return 12;
                }
                case 22: {
                    return 13;
                }
                case 23: {
                    return 14;
                }
                case 24: {
                    return 15;
                }
                case 25: {
                    return 16;
                }
                case 26: {
                    return 17;
                }
                case 27: {
                    return 18;
                }
                case 28: {
                    return 19;
                }
                case 29: {
                    return 20;
                }
                case 30: {
                    return 21;
                }
                case 31: {
                    return 22;
                }
                case 32: {
                    return 23;
                }
                case 33: {
                    return 24;
                }
            }
            return -1;
        }
        if (baseClass == XmlEntity.class) {
            switch (derivedFeatureID) {
                case 34: {
                    return 25;
                }
                case 35: {
                    return 26;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == XmlEntityForXml.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 7;
                }
                case 1: {
                    return 8;
                }
                case 2: {
                    return 9;
                }
                case 3: {
                    return 10;
                }
            }
            return -1;
        }
        if (baseClass == IEntity.class) {
            switch (baseFeatureID) {
                case 2: {
                    return 11;
                }
                case 3: {
                    return 12;
                }
                case 4: {
                    return 13;
                }
                case 5: {
                    return 14;
                }
                case 6: {
                    return 15;
                }
                case 7: {
                    return 16;
                }
                case 8: {
                    return 17;
                }
                case 9: {
                    return 18;
                }
                case 10: {
                    return 19;
                }
                case 11: {
                    return 20;
                }
                case 12: {
                    return 21;
                }
                case 13: {
                    return 22;
                }
                case 14: {
                    return 23;
                }
                case 15: {
                    return 24;
                }
                case 16: {
                    return 25;
                }
                case 17: {
                    return 26;
                }
                case 18: {
                    return 27;
                }
                case 19: {
                    return 28;
                }
                case 20: {
                    return 29;
                }
                case 21: {
                    return 30;
                }
                case 22: {
                    return 31;
                }
                case 23: {
                    return 32;
                }
                case 24: {
                    return 33;
                }
            }
            return -1;
        }
        if (baseClass == XmlEntity.class) {
            switch (baseFeatureID) {
                case 25: {
                    return 34;
                }
                case 26: {
                    return 35;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (specifiedName: ");
        result.append(this.specifiedName);
        result.append(", defaultName: ");
        result.append(this.defaultName);
        result.append(", inheritanceStrategy: ");
        result.append((Object)this.inheritanceStrategy);
        result.append(", defaultDiscriminatorValue: ");
        result.append(this.defaultDiscriminatorValue);
        result.append(", specifiedDiscriminatorValue: ");
        result.append(this.specifiedDiscriminatorValue);
        result.append(", idClass: ");
        result.append(this.idClass);
        result.append(')');
        return result.toString();
    }

    @Override
    public String getTableName() {
        return this.getTable().getName();
    }

    public void makeTableForXmlNull() {
        this.setTableForXmlGen(null);
    }

    public void makeTableForXmlNonNull() {
        this.setTableForXmlGen(this.getTableForXml());
    }

    public void makeDiscriminatorColumnForXmlNull() {
        this.setDiscriminatorColumnForXmlGen(null);
    }

    public void makeDiscriminatorColumnForXmlNonNull() {
        this.setDiscriminatorColumnForXmlGen(this.getDiscriminatorColumnForXml());
    }

    @Override
    public String primaryKeyColumnName() {
        String pkColumnName = null;
        Iterator<IPersistentAttribute> stream = this.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            IPersistentAttribute attribute = stream.next();
            String name = attribute.primaryKeyColumnName();
            if (pkColumnName == null) {
                pkColumnName = name;
                continue;
            }
            if (name == null) continue;
            return null;
        }
        return pkColumnName;
    }

    @Override
    public String primaryKeyAttributeName() {
        String pkColumnName = null;
        String pkAttributeName = null;
        Iterator<IPersistentAttribute> stream = this.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            IPersistentAttribute attribute = stream.next();
            String name = attribute.primaryKeyColumnName();
            if (pkColumnName == null) {
                pkColumnName = name;
                pkAttributeName = attribute.getName();
                continue;
            }
            if (name == null) continue;
            return null;
        }
        return pkAttributeName;
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !CollectionTools.contains(this.associatedTableNamesIncludingInherited(), (Object)tableName);
    }

    private Iterator<String> tableNames(Iterator<ITable> tables) {
        return new TransformationIterator(tables){

            protected Object transform(Object next) {
                return ((ITable)next).getName();
            }
        };
    }

    @Override
    public Iterator<String> associatedTableNamesIncludingInherited() {
        return this.nonNullTableNames(this.associatedTablesIncludingInherited());
    }

    private Iterator<String> nonNullTableNames(Iterator<ITable> tables) {
        return new FilteringIterator(this.tableNames(tables)){

            protected boolean accept(Object o) {
                return o != null;
            }
        };
    }

    @Override
    public Iterator<ITable> associatedTables() {
        return new CompositeIterator((Object)this.getTable(), this.getSecondaryTables().iterator());
    }

    @Override
    public Iterator<ITable> associatedTablesIncludingInherited() {
        return new CompositeIterator((Iterator)new TransformationIterator(this.inheritanceHierarchy()){

            protected Object transform(Object next) {
                return new FilteringIterator(((ITypeMapping)next).associatedTables()){

                    protected boolean accept(Object o) {
                        return true;
                    }
                };
            }
        });
    }

    @Override
    public Table primaryDbTable() {
        return this.getTable().dbTable();
    }

    @Override
    public Table dbTable(String tableName) {
        Iterator<ITable> stream = this.associatedTablesIncludingInherited();
        while (stream.hasNext()) {
            Table dbTable = stream.next().dbTable();
            if (dbTable == null || !dbTable.matchesShortJavaClassName(tableName)) continue;
            return dbTable;
        }
        return null;
    }

    @Override
    public Schema dbSchema() {
        return this.getTable().dbSchema();
    }

    @Override
    public int xmlSequence() {
        return 1;
    }

    private Iterator<ITypeMapping> inheritanceHierarchy() {
        return new TransformationIterator(this.getPersistentType().inheritanceHierarchy()){

            protected Object transform(Object next) {
                return ((IPersistentType)next).getMapping();
            }
        };
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator(this.inheritanceHierarchy()){

            protected Object transform(Object next) {
                return ((ITypeMapping)next).overridableAttributeNames();
            }
        });
    }

    @Override
    public Iterator<String> allOverridableAssociationNames() {
        return new CompositeIterator((Iterator)new TransformationIterator(this.inheritanceHierarchy()){

            protected Object transform(Object next) {
                return ((ITypeMapping)next).overridableAssociationNames();
            }
        });
    }

    @Override
    public IAttributeOverride createAttributeOverride(int index) {
        return OrmFactory.eINSTANCE.createXmlAttributeOverride(new IEntity.AttributeOverrideOwner(this));
    }

    @Override
    public IAssociationOverride createAssociationOverride(int index) {
        return OrmFactory.eINSTANCE.createXmlAssociationOverride(new IEntity.AssociationOverrideOwner(this));
    }

    @Override
    public IAttributeOverride attributeOverrideNamed(String name) {
        return (IAttributeOverride)this.overrideNamed(name, (List<? extends IOverride>)this.getAttributeOverrides());
    }

    @Override
    public boolean containsAttributeOverride(String name) {
        return this.containsOverride(name, (List<? extends IOverride>)this.getAttributeOverrides());
    }

    @Override
    public boolean containsSpecifiedAttributeOverride(String name) {
        return this.containsOverride(name, (List<? extends IOverride>)this.getSpecifiedAttributeOverrides());
    }

    @Override
    public boolean containsAssociationOverride(String name) {
        return this.containsOverride(name, (List<? extends IOverride>)this.getAssociationOverrides());
    }

    @Override
    public boolean containsSpecifiedAssociationOverride(String name) {
        return this.containsOverride(name, (List<? extends IOverride>)this.getSpecifiedAssociationOverrides());
    }

    private IOverride overrideNamed(String name, List<? extends IOverride> overrides) {
        for (IOverride iOverride : overrides) {
            String overrideName = iOverride.getName();
            if (overrideName == null && name == null) {
                return iOverride;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return iOverride;
        }
        return null;
    }

    private boolean containsOverride(String name, List<? extends IOverride> overrides) {
        return this.overrideNamed(name, overrides) != null;
    }

    @Override
    public ISecondaryTable createSecondaryTable(int index) {
        return OrmFactory.eINSTANCE.createXmlSecondaryTable(this.buildSecondaryTableOwner());
    }

    private ITable.Owner buildSecondaryTableOwner() {
        return new ITable.Owner(){

            public ITextRange validationTextRange() {
                return XmlEntityInternal.this.validationTextRange();
            }

            public ITypeMapping getTypeMapping() {
                return XmlEntityInternal.this;
            }
        };
    }

    @Override
    public boolean containsSpecifiedPrimaryKeyJoinColumns() {
        return !this.getSpecifiedPrimaryKeyJoinColumns().isEmpty();
    }

    @Override
    public IPrimaryKeyJoinColumn createPrimaryKeyJoinColumn(int index) {
        return OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn(new IEntity.PrimaryKeyJoinColumnOwner(this));
    }

    @Override
    public INamedQuery createNamedQuery(int index) {
        return OrmFactory.eINSTANCE.createXmlNamedQuery();
    }

    @Override
    public INamedNativeQuery createNamedNativeQuery(int index) {
        return OrmFactory.eINSTANCE.createXmlNamedNativeQuery();
    }
}

