/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilderImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HTMLContentBuilder
extends DOMContentBuilderImpl {
    private int fTagCase;
    private int fAttrCase;

    public HTMLContentBuilder(Document document) {
        super(document);
        Preferences prefs = HTMLCorePlugin.getDefault().getPluginPreferences();
        this.fTagCase = prefs.getInt("tagNameCase");
        this.fAttrCase = prefs.getInt("attrNameCase");
    }

    public String computeName(CMNode cmnode, Node parent) {
        String name = super.computeName(cmnode, parent);
        if (this.shouldIgnoreCase(cmnode)) {
            if (cmnode.getNodeType() == 5) {
                if (this.fTagCase == 1) {
                    name = name.toLowerCase();
                } else if (this.fTagCase == 2) {
                    name = name.toUpperCase();
                }
            } else if (cmnode.getNodeType() == 2) {
                if (this.fAttrCase == 1) {
                    name = name.toLowerCase();
                } else if (this.fAttrCase == 2) {
                    name = name.toUpperCase();
                }
            }
        }
        return name;
    }

    private boolean shouldIgnoreCase(CMNode cmnode) {
        if (!cmnode.supports("shouldIgnoreCase")) {
            return false;
        }
        return (Boolean)cmnode.getProperty("shouldIgnoreCase");
    }
}

