/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.internal.deploy.ui.editors.DeployEditorSectionPart;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.help.HelpUtilities;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PackageDescriptionSection
extends DeployEditorSectionPart
implements IPartSelectionListener {
    public static final String SECTION_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.SECTITLE.PackageDescription");
    public static final String SECTION_DESC = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.SECDESC.PackageDescription");
    private Text mDescText;

    public PackageDescriptionSection(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
        this.getSection().setText(SECTION_TITLE);
        this.getSection().setDescription(SECTION_DESC);
    }

    public void createClient(FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)this.getSection());
        GridLayout layout = EnhancedFormEditor.newSectionGridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        this.mDescText = toolkit.createText(container, new String(), 586);
        GridData gd = new GridData(1808);
        gd.heightHint = this.mDescText.getLineHeight() * 5;
        this.mDescText.setLayoutData((Object)gd);
        this.getSection().setClient((Control)container);
        toolkit.paintBordersFor(container);
    }

    protected void helpActivated(HyperlinkEvent event) {
        HelpUtilities.displayHelp((String)IHelpConstants.CONTEXT_ID_CONFIGURATION_PAGE_PACKAGE_DESCRIPTION_SECTION);
    }

    protected void setModelRoot(EObject modelRoot) {
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IPackage pkg;
        Object element;
        if (!selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject && (pkg = Utilities.adaptToIPackage((EObject)element)) != null) {
            String description = pkg.getDescription();
            if (description == null) {
                description = new String();
            }
            this.mDescText.setText(description);
        }
    }
}

