/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.properties;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

class DeploymentResource {
    private IProject project = null;
    private IWorkspaceRoot workspaceRoot = null;
    public static final String DEPLOYMENT_OUTPUT_FOLDER = "deploymenet.output.folder";
    public static final String DEFAULT_DEPLOYMENT_FOLDER = "Deployment";
    private static final String DEPLOYMENT_OUTPUT_FILE = ".deployment";

    public DeploymentResource(IProject project) {
        this.project = project;
        this.workspaceRoot = this.project.getWorkspace().getRoot();
    }

    public String getOutputFolder() {
        Properties properties = new Properties();
        try {
            properties.load(this.getInputStream());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
        String folderPath = properties.getProperty(DEPLOYMENT_OUTPUT_FOLDER);
        String projectName = this.project.getName();
        StringBuffer pathBuf = new StringBuffer();
        pathBuf.append("/").append(projectName).append("/").append(folderPath);
        return pathBuf.toString();
    }

    public void setOutputFolder(String path) {
        String projectName = this.project.getName();
        Path tempPath = new Path(path);
        IPath resultPath = tempPath.removeFirstSegments(1);
        InputStream inputStream = this.generateInputStream(resultPath.toString());
        IPath filePath = this.workspaceRoot.getFullPath().append(projectName);
        filePath = filePath.append("/");
        filePath = filePath.append(DEPLOYMENT_OUTPUT_FILE);
        IFile deploymentFile = this.workspaceRoot.getFile(filePath);
        try {
            if (deploymentFile == null) {
                deploymentFile.create(inputStream, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                deploymentFile.setContents(inputStream, true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            inputStream.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private InputStream getInputStream() throws CoreException {
        String projectName = this.project.getName();
        IPath filePath = this.workspaceRoot.getFullPath().append(projectName);
        filePath = filePath.append("/");
        IFile deploymentFile = this.workspaceRoot.getFile(filePath = filePath.append(DEPLOYMENT_OUTPUT_FILE));
        if (deploymentFile == null || !deploymentFile.exists()) {
            deploymentFile.create(this.generateInputStream(DEFAULT_DEPLOYMENT_FOLDER), true, (IProgressMonitor)new NullProgressMonitor());
        }
        return deploymentFile.getContents(true);
    }

    private InputStream generateInputStream(String path) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(DEPLOYMENT_OUTPUT_FOLDER);
        strBuf.append("=");
        strBuf.append(path);
        return new ByteArrayInputStream(strBuf.toString().getBytes());
    }
}

