/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsp.core;

public class ListenerList {
    private int _size;
    private Object[] _listeners = null;
    private static final Object[] EmptyArray = new Object[0];

    public ListenerList(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this._listeners = new Object[capacity];
        this._size = 0;
    }

    public synchronized void add(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this._size) {
            if (this._listeners[i] == listener) {
                return;
            }
            ++i;
        }
        if (this._size == this._listeners.length) {
            Object[] temp = new Object[this._size * 2 + 1];
            System.arraycopy(this._listeners, 0, temp, 0, this._size);
            this._listeners = temp;
        }
        this._listeners[this._size++] = listener;
    }

    public synchronized Object[] getListeners() {
        if (this._size == 0) {
            return EmptyArray;
        }
        Object[] result = new Object[this._size];
        System.arraycopy(this._listeners, 0, result, 0, this._size);
        return result;
    }

    public synchronized void remove(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this._size) {
            if (this._listeners[i] == listener) {
                if (--this._size == 0) {
                    this._listeners = new Object[1];
                } else {
                    if (i < this._size) {
                        this._listeners[i] = this._listeners[this._size];
                    }
                    this._listeners[this._size] = null;
                }
                return;
            }
            ++i;
        }
    }

    public void removeAll() {
        this._listeners = new Object[0];
        this._size = 0;
    }

    public int size() {
        return this._size;
    }
}

