/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.service;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.service.ITraversalStrategy;

public abstract class AbstractTraversalStrategy
implements ITraversalStrategy {
    private static final String VALIDATING_TASK = ValidationMessages.progress_task_validating;
    private static final int PROGRESS_EXPANSION_COEFFICIENT = 8;
    private static final int MAX_PROGRESS_TICKS = 2048;
    private Iterator iterator;
    private IProgressMonitor monitor;

    public void startTraversal(Collection traversalRoots, IProgressMonitor progressMonitor) {
        int taskSize;
        int scaledSize = taskSize = this.countElements(traversalRoots);
        while (scaledSize > 2048) {
            scaledSize /= 8;
        }
        progressMonitor.beginTask(this.getTaskLabel(), scaledSize);
        if (scaledSize == taskSize) {
            this.monitor = progressMonitor;
        } else {
            this.monitor = new SubProgressMonitor(progressMonitor, scaledSize, 2);
            this.monitor.beginTask("", taskSize);
        }
        this.iterator = this.createIterator(traversalRoots);
    }

    protected String getTaskLabel() {
        return VALIDATING_TASK;
    }

    protected abstract int countElements(Collection var1);

    protected abstract Iterator createIterator(Collection var1);

    protected IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public EObject next() {
        return (EObject)this.iterator.next();
    }

    public boolean isClientContextChanged() {
        return true;
    }

    public void elementValidated(EObject element, IStatus status) {
        this.getProgressMonitor().worked(1);
    }
}

