/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.logging;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.common.Activator;
import org.eclipse.stp.common.logging.ILogWriter;
import org.eclipse.stp.common.logging.SystemOutWriter;

public final class LoggingProxy
implements ILogWriter {
    public static final String LOG_LEVEL_DEBUG = "org.eclipse.stp.common/debug";
    public static final String LOG_LEVEL_INFO = "org.eclipse.stp.common/info";
    public static final String LOG_LEVEL_ERROR = "org.eclipse.stp.common/error";
    private static final String OPTION_ENABLED = "true";
    private String[] tracingOptions;
    private ILogWriter writer;

    private LoggingProxy(Class aLogRoot, String[] someTracingOptions) {
        this.tracingOptions = someTracingOptions;
        this.writer = new SystemOutWriter(aLogRoot);
    }

    public static LoggingProxy getlogger(Class aLogRoot, String[] someTracingOptions) {
        return new LoggingProxy(aLogRoot, someTracingOptions);
    }

    public static LoggingProxy getlogger(Class aLogRoot, String aTracingOption) {
        return new LoggingProxy(aLogRoot, new String[]{aTracingOption});
    }

    public static LoggingProxy getlogger(Class aLogRoot) {
        return new LoggingProxy(aLogRoot, null);
    }

    private boolean checkLogOptions(String[] extraTracingOptions) {
        int i = 0;
        while (this.tracingOptions != null && i < this.tracingOptions.length) {
            if (!OPTION_ENABLED.equals(Platform.getDebugOption((String)this.tracingOptions[i]))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (extraTracingOptions != null && i < extraTracingOptions.length) {
            if (!OPTION_ENABLED.equals(Platform.getDebugOption((String)extraTracingOptions[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void debug(Object message, Throwable t) {
        if (this.checkLogOptions(new String[]{LOG_LEVEL_DEBUG})) {
            this.writer.debug(message, t);
        }
    }

    public void debug(Object message) {
        if (this.checkLogOptions(new String[]{LOG_LEVEL_DEBUG})) {
            this.writer.debug(message);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.checkLogOptions(new String[]{LOG_LEVEL_INFO})) {
            this.writer.info(message, t);
        }
    }

    public void info(Object message) {
        if (this.checkLogOptions(new String[]{LOG_LEVEL_INFO})) {
            this.writer.info(message);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.checkLogOptions(new String[]{LOG_LEVEL_ERROR})) {
            this.writer.error(message, t);
        }
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.common", 0, message.toString(), t));
    }

    public void error(Object message) {
        if (this.checkLogOptions(new String[]{LOG_LEVEL_ERROR})) {
            this.writer.error(message);
        }
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.common", 0, message.toString(), null));
    }
}

