/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.enablejaxws;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IStartingPointPageContents;
import org.eclipse.stp.sc.jaxws.wizards.StartingPointWizardPage;
import org.eclipse.stp.sc.jaxws.wizards.enablejaxws.StartingPointPageContents;

public class StartingPointPage
extends StartingPointWizardPage {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(StartingPointPage.class);

    public StartingPointPage(String pageName) {
        super(pageName);
        this.setDescription("Specify the starting point as the web service class.");
        this.setTitle("Starting Point");
    }

    public void performFinish(IProject project) {
        try {
            String filePath = ((IStartingPointPageContents)this.pageContents).getStartingPoint();
            IFile targetFile = ResourceUtils.getFileFromPath((String)filePath);
            project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT, targetFile.getProjectRelativePath().toOSString());
            project.build(10, null);
            this.annotateStartPointClass(project);
            ResourceUtils.selectAndOpenResource((IFile)targetFile);
            JavaCore.create((IProject)project).save(null, false);
            project.build(10, null);
        }
        catch (Exception ex) {
            LOG.error((Object)"error during import the starting point", (Throwable)ex);
        }
    }

    public void updateControl(String newRuntimeType) {
    }

    public void setRuntimeInfo(String runtimeType, String runtimeID) {
        ((StartingPointPageContents)this.pageContents).setRuntimeInfo(runtimeType, runtimeID);
    }
}

