/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.wsdltojava;

import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.common.utils.FileUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaGenerator;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.utils.MergeUtils;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class WsdlToJavaGenerateAction {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlToJavaGenerateAction.class);
    private static final String TEMP_DIR = "gentmp";
    private boolean needMerge = true;

    public synchronized void generate(String url, IProject project, Object data) throws CoreException {
        boolean isAutoBuild = WorkspaceManager.getWorkspaceAutoBuild();
        try {
            try {
                long startTime = System.currentTimeMillis();
                if (isAutoBuild) {
                    LOG.debug((Object)"disable workspace autobuild before generating code");
                    WorkspaceManager.setWorkspaceAutoBuild((boolean)false);
                }
                String runtimeType = RuntimeCore.getRuntimeType((IProject)project);
                IWsdlToJavaGenerator generator = RuntimeProviderManager.getInstance().getWsdltoJavaGenerator(runtimeType);
                if (data != null) {
                    generator.setInitializationData(null, null, data);
                }
                IPreferenceStore preferenceStore = ScJaxWsPlugin.getDefault().getPreferenceStore();
                boolean mergeFlg = preferenceStore.getBoolean("KEY_MERGE");
                if (!this.needMerge) {
                    mergeFlg = false;
                }
                String oldDir = null;
                String newDir = null;
                if (mergeFlg) {
                    Hashtable genParams = (Hashtable)data;
                    oldDir = (String)genParams.get("GEN_OUTPUTDIR");
                    newDir = this.prepareMergeTmpDir(oldDir, genParams);
                }
                generator.run(url, project);
                if (mergeFlg) {
                    this.mergeDir(oldDir, newDir, true);
                }
                project.refreshLocal(2, null);
                this.tagGeneratedFiles((IContainer)project, startTime, url);
            }
            catch (Throwable th) {
                th.printStackTrace();
                if (isAutoBuild) {
                    LOG.debug((Object)"re-enable workspace autobuild after generating code");
                    project.refreshLocal(2, null);
                    WorkspaceManager.setWorkspaceAutoBuild((boolean)true);
                }
            }
        }
        finally {
            if (isAutoBuild) {
                LOG.debug((Object)"re-enable workspace autobuild after generating code");
                project.refreshLocal(2, null);
                WorkspaceManager.setWorkspaceAutoBuild((boolean)true);
            }
        }
    }

    private void tagGeneratedFiles(IContainer container, long startTime, String wsdlUrl) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res.exists()) {
                    IFile file;
                    if (res instanceof IContainer) {
                        this.tagGeneratedFiles((IContainer)res, startTime, wsdlUrl);
                    }
                    if (res instanceof IFile && (file = (IFile)res).getFileExtension() != null && file.getFileExtension().equals("java") && file.getLocalTimeStamp() > startTime) {
                        file.setPersistentProperty(JaxWsWorkspaceManager.WSDL_PROPERTY, wsdlUrl);
                        LOG.debug((Object)("attach wsdl property for " + file.getLocation().toOSString()));
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error during tag generated java file", (Throwable)e);
        }
    }

    private String prepareMergeTmpDir(String oldDir, Hashtable genParams) {
        String mergeDir = String.valueOf(oldDir) + File.separator + TEMP_DIR;
        File file = new File(mergeDir);
        if (file.exists()) {
            file.delete();
        }
        file.mkdir();
        genParams.put("GEN_OUTPUTDIR", mergeDir);
        return mergeDir;
    }

    public void mergeDir(String oldDir, String newDir, boolean forceMerge) {
        LOG.debug((Object)("merge olddir:" + oldDir + " newDir:" + newDir));
        File newDirFile = null;
        File oldDirFile = null;
        try {
            int n;
            int n2;
            File[] fileArray;
            newDirFile = new File(newDir);
            oldDirFile = new File(oldDir);
            if (!oldDirFile.exists()) {
                oldDirFile.mkdir();
            }
            Hashtable<String, File> oldFilesTab = new Hashtable<String, File>();
            if (oldDirFile.listFiles() != null) {
                fileArray = oldDirFile.listFiles();
                n2 = fileArray.length;
                n = 0;
                while (n < n2) {
                    File oldFile = fileArray[n];
                    oldFilesTab.put(oldFile.getName(), oldFile);
                    ++n;
                }
            }
            if (newDirFile.listFiles() == null) {
                return;
            }
            fileArray = newDirFile.listFiles();
            n2 = fileArray.length;
            n = 0;
            while (n < n2) {
                File file = fileArray[n];
                String targetFile = String.valueOf(oldDir) + File.separator + file.getName();
                if (file.isDirectory()) {
                    this.mergeDir(targetFile, file.getAbsolutePath(), forceMerge);
                } else {
                    if (oldFilesTab.containsKey(file.getName()) && this.needMerge(file.getName()) && forceMerge) {
                        LOG.debug((Object)("merge file:" + file.getAbsolutePath() + " and " + targetFile));
                        MergeUtils.mergeJavaFile(targetFile, file.getAbsolutePath(), targetFile);
                    } else {
                        FileUtils.copyFile((String)file.getAbsolutePath(), (String)oldDir);
                    }
                    file.delete();
                }
                ++n;
            }
            newDirFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)"error during merge dir", (Throwable)e);
        }
    }

    private boolean needMerge(String fileName) {
        if (fileName.endsWith("Impl.java")) {
            return true;
        }
        if (fileName.endsWith("Client.java")) {
            return true;
        }
        return fileName.endsWith("Server.java");
    }

    public boolean isNeedMerge() {
        return this.needMerge;
    }

    public void setNeedMerge(boolean value) {
        this.needMerge = value;
    }
}

