/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.sca.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;
import org.eclipse.stp.core.sca.impl.ComponentWireHandleImpl;

final class ComponentWireSourceHandle
extends ComponentWireHandleImpl
implements WireSource {
    private Reference reference;
    private String referenceName;

    ComponentWireSourceHandle(Component component, Reference reference) {
        super(component);
        this.reference = reference;
    }

    ComponentWireSourceHandle(Component component, String referenceName) {
        super(component);
        this.referenceName = referenceName;
    }

    public String getName() {
        StringBuffer buf = new StringBuffer(this.getOwningComponent().getName());
        buf.append('/').append(this.getReferenceName());
        return buf.toString();
    }

    private String getReferenceName() {
        return this.reference == null ? this.referenceName : this.reference.getName();
    }

    public Interface getInterface() {
        return this.isResolved() ? this.reference.getInterface() : null;
    }

    public boolean matches(WireTarget wireTarget) {
        Assert.isNotNull((Object)wireTarget);
        if (this.getInterface() != null) {
            return this.getInterface().equals(wireTarget.getInterface());
        }
        return false;
    }

    public int getFlags() {
        return 1;
    }

    public EObject getEObject() {
        return this.getOwningComponent().getEObject();
    }

    public void setName(String name) {
        Assert.isNotSupported((String)"ComponentWireSourceHandle#setName(String)");
    }

    public void createWireToTarget(WireTarget wireTarget) {
        if (this.isResolved()) {
            this.getOwningComponent().setReferenceValue(this.reference, wireTarget);
        }
    }

    public List getWiredTargets() {
        List values = this.getOwningComponent().getReferenceValues(this.getReferenceName());
        if (values.isEmpty()) {
            return values;
        }
        if (values.size() == 1) {
            ReferenceValue wire = (ReferenceValue)values.get(0);
            return Collections.singletonList(wire.getTarget());
        }
        ArrayList<WireTarget> targets = new ArrayList<WireTarget>(values.size());
        int i = 0;
        while (i < values.size()) {
            targets.add(((ReferenceValue)values.get(i)).getTarget());
            ++i;
        }
        return Collections.unmodifiableList(targets);
    }

    public String toString() {
        return this.getName();
    }

    void destroy() {
        this.reference = null;
        super.destroy();
    }

    public boolean deleteWireToTarget(WireTarget wireTarget) {
        ReferenceValue refValue;
        if (wireTarget != null && (refValue = this.getReferenceValue(wireTarget)) != null) {
            return this.getOwningComponent().getReferenceValues().remove(refValue);
        }
        return false;
    }

    private ReferenceValue getReferenceValue(WireTarget wireTarget) {
        List wires;
        ReferenceValue refValue = null;
        String referenceName = this.getReferenceName();
        if (this.getOwningComponent() != null && referenceName != null && !(wires = this.getOwningComponent().getReferenceValues(referenceName)).isEmpty()) {
            int i = 0;
            while (i < wires.size()) {
                refValue = (ReferenceValue)wires.get(i);
                if (refValue.targets(wireTarget)) break;
                refValue = null;
                ++i;
            }
        }
        return refValue;
    }

    public boolean isResolved() {
        this.resolveReference();
        return this.reference != null;
    }

    private void resolveReference() {
        ComponentType type = this.getOwningComponent().resolveComponentType();
        if (type != null) {
            Reference test = type.getReference(this.getReferenceName());
            if (test != null) {
                this.reference = test;
                this.referenceName = null;
            } else {
                if (this.reference != null) {
                    this.referenceName = this.reference.getName();
                }
                this.reference = null;
            }
        }
    }
}

