/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxwsri.generators;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IParameterPage;
import org.eclipse.stp.sc.jaxwsri.JAXWSRIResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSRIWsdlToJavaParameterPage
implements IParameterPage {
    public static final String KEY_BINDING_FILE_LIST = "KEY_BINDING_FILE_LIST";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JAXWSRIWsdlToJavaParameterPage.class);
    Button btBindingFile = null;
    Text txtBindingFiles = null;
    Button btBrowse = null;
    Button btVerbose = null;
    HashMap<String, Object> params = new HashMap();
    Shell parentShell = null;
    WizardPage hostPage = null;
    String wsdlUrl;

    public Control createContents(Composite parent) {
        this.parentShell = parent.getShell();
        Composite compBinding = new Composite(parent, 0);
        compBinding.setLayoutData((Object)new GridData(768));
        compBinding.setLayout((Layout)new GridLayout(2, false));
        this.btBindingFile = new Button(compBinding, 32);
        this.btBindingFile.setText(JAXWSRIResources.getString("Wsdl.To.Java.BindingFile.Checkbox.Text"));
        this.btBindingFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JAXWSRIWsdlToJavaParameterPage.this.txtBindingFiles.setEnabled(JAXWSRIWsdlToJavaParameterPage.this.btBindingFile.getSelection());
                JAXWSRIWsdlToJavaParameterPage.this.btBrowse.setEnabled(JAXWSRIWsdlToJavaParameterPage.this.btBindingFile.getSelection());
                JAXWSRIWsdlToJavaParameterPage.this.validateParams();
            }
        });
        new Text(compBinding, 23).setVisible(false);
        this.txtBindingFiles = new Text(compBinding, 2052);
        this.txtBindingFiles.setLayoutData((Object)new GridData(768));
        this.txtBindingFiles.setEnabled(false);
        this.txtBindingFiles.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JAXWSRIWsdlToJavaParameterPage.this.validateParams();
            }
        });
        this.btBrowse = new Button(compBinding, 8);
        this.btBrowse.setText(JAXWSRIResources.getString("Wsdl.To.Java.Browse.Binding.Button"));
        this.btBrowse.setEnabled(false);
        this.btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LOG.debug((Object)"Browsing button is pressed");
                FileDialog fileChooser = new FileDialog(JAXWSRIWsdlToJavaParameterPage.this.parentShell, 4098);
                String result = fileChooser.open();
                if (result != null) {
                    String[] names = fileChooser.getFileNames();
                    String path = fileChooser.getFilterPath();
                    StringBuffer sbValue = new StringBuffer();
                    int i = 0;
                    while (i < names.length) {
                        sbValue.append(String.valueOf(path) + names[i]);
                        if (i < names.length - 1) {
                            sbValue.append(", ");
                        }
                        ++i;
                    }
                    JAXWSRIWsdlToJavaParameterPage.this.txtBindingFiles.setText(sbValue.toString());
                }
                JAXWSRIWsdlToJavaParameterPage.this.validateParams();
            }
        });
        Composite compMisc = new Composite(parent, 0);
        compMisc.setLayoutData((Object)new GridData(768));
        compMisc.setLayout((Layout)new GridLayout(2, false));
        this.btVerbose = new Button(compMisc, 32);
        this.btVerbose.setText(JAXWSRIResources.getString("Wsdl.To.Java.Mist.Verbose.Text"));
        this.btVerbose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JAXWSRIWsdlToJavaParameterPage.this.btVerbose.getSelection()) {
                    JAXWSRIWsdlToJavaParameterPage.this.params.put("-verbose", "");
                } else {
                    JAXWSRIWsdlToJavaParameterPage.this.params.remove("-verbose");
                }
                JAXWSRIWsdlToJavaParameterPage.this.validateParams();
            }
        });
        return parent;
    }

    public Map<String, Object> getParameters() {
        return this.params;
    }

    public void performOK() {
        if (this.btBindingFile.getSelection()) {
            String bFileStr = this.btBindingFile.getText();
            StringTokenizer tkzr = new StringTokenizer(bFileStr, ",");
            ArrayList<String> listFiles = new ArrayList<String>();
            while (tkzr.hasMoreTokens()) {
                String fPath = tkzr.nextToken();
                listFiles.add(fPath);
            }
            this.params.put(KEY_BINDING_FILE_LIST, listFiles);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public String validateParams() {
        String result = null;
        if (this.btBindingFile.getSelection()) {
            if (this.txtBindingFiles.getText().trim().equals("")) {
                result = JAXWSRIResources.getString("Wsdl.To.Java.Param.Binding.File.Empty");
            } else {
                String bFileStr = this.txtBindingFiles.getText();
                StringTokenizer tkzr = new StringTokenizer(bFileStr, ",");
                while (tkzr.hasMoreTokens()) {
                    String fPath = tkzr.nextToken();
                    LOG.debug((Object)("File Path: " + fPath));
                    File file = new File(fPath);
                    if (!file.exists()) {
                        result = String.valueOf(JAXWSRIResources.getString("Wsdl.To.Java.Param.File.Not.Exist")) + fPath;
                        break;
                    }
                    if (!file.isDirectory()) continue;
                    result = String.valueOf(JAXWSRIResources.getString("Wsdl.To.Java.Param.File.Is.Dir")) + fPath;
                    break;
                }
            }
        }
        this.hostPage.setErrorMessage(result);
        this.hostPage.setPageComplete(result == null);
        return result;
    }

    public void setPage(WizardPage page) {
        this.hostPage = page;
    }

    public void setWsdlUrl(String url) {
        LOG.debug((Object)("set WsdlURL called:" + url));
        this.wsdlUrl = url;
    }
}

