/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.internal.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class RuntimeCore {
    public static final QualifiedName RUNTIMETYPE_PROPERTY = new QualifiedName("stp", "runtimeType");
    public static final QualifiedName RUNTIMEID_PROPERTY = new QualifiedName("stp", "runtimeId");
    public static final String JAXWS_MODULE_TYPE = "stp.jaxws.component";
    public static final String SCA_MODULE_TYPE = "stp.sca.component";
    public static final String JAXWS_KIT_TESTPROPERTY = "jaxws_kit_location";
    public static final String SCA_KIT_TESTPROPERTY = "sca_kit_location";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeCore.class);

    public static IRuntime getRuntime(IProject project) {
        String runtimeId = RuntimeCore.getRuntimeID(project);
        return RuntimeCore.getRuntime(runtimeId);
    }

    public static IRuntime getRuntime(String runtimeId) {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            IRuntime[] iRuntimeArray = runtimes;
            int n = runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime runtime = iRuntimeArray[n2];
                if (runtime.getId().equals(runtimeId)) {
                    return runtime;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IPath getInstallPath(IProject project) {
        String runtimeId = RuntimeCore.getRuntimeID(project);
        return RuntimeCore.getInstallPath(runtimeId);
    }

    public static IPath getInstallPath(String runtimeId) {
        IRuntime runtime = RuntimeCore.getRuntime(runtimeId);
        if (runtime != null) {
            return runtime.getLocation();
        }
        String property = System.getProperty(JAXWS_KIT_TESTPROPERTY);
        if (property != null) {
            return new Path(property);
        }
        LOG.error((Object)("can't find the runtime with id:" + runtimeId));
        return null;
    }

    public static String getRuntimeType(IProject project) {
        try {
            return project.getPersistentProperty(RUNTIMETYPE_PROPERTY);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setRuntimeType(IProject project, String runtimeType) {
        try {
            project.setPersistentProperty(RUNTIMETYPE_PROPERTY, runtimeType);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static String getRuntimeID(IProject project) {
        try {
            return project.getPersistentProperty(RUNTIMEID_PROPERTY);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setRuntimeID(IProject project, String runtimeId) {
        try {
            project.setPersistentProperty(RUNTIMEID_PROPERTY, runtimeId);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void createServer(String serverType, String serverId) {
        try {
            IServerType[] iServerTypeArray = ServerCore.getServerTypes();
            int n = iServerTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IServerType type = iServerTypeArray[n2];
                if (type.equals(serverType)) {
                    IServerWorkingCopy workingCopy = type.createServer(serverId, null, null);
                    workingCopy.save(true, null);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error during create server.", (Throwable)e);
        }
    }

    public static String creatRuntime(String runtimeType, String runtimeId, IPath location) {
        try {
            IRuntimeType[] iRuntimeTypeArray = ServerCore.getRuntimeTypes();
            int n = iRuntimeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntimeType type = iRuntimeTypeArray[n2];
                if (type.getId().equals(runtimeType)) {
                    IRuntimeWorkingCopy workingCopy = type.createRuntime(runtimeId, null);
                    workingCopy.setLocation(location);
                    IRuntime runtime = workingCopy.save(true, null);
                    return runtime.getId();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error during create runtime.", (Throwable)e);
        }
        return null;
    }

    public static String getRuntimeIdWithoutVersion(String id) {
        int index = id.lastIndexOf(".");
        if (index >= 0) {
            return id.substring(0, index);
        }
        return "";
    }
}

