/**
 * <copyright> </copyright>
 * 
 * $Id: ModuleImpl.java,v 1.1 2006-03-31 21:58:48 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Module</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * </p>
 * 
 * @generated
 */
public class ModuleImpl extends ModuleFragmentImpl implements Module {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getModule();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.MODULE__ENTRY_POINTS:
               return ((InternalEList) getEntryPoints()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.MODULE__COMPONENTS_GROUP:
               return ((InternalEList) getComponentsGroup()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.MODULE__COMPONENTS:
               return ((InternalEList) getComponents()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.MODULE__EXTERNAL_SERVICES:
               return ((InternalEList) getExternalServices()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.MODULE__WIRES:
               return ((InternalEList) getWires()).basicRemove(otherEnd, msgs);
            case SCAPackage.MODULE__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.MODULE__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE__ENTRY_POINTS:
            return getEntryPoints();
         case SCAPackage.MODULE__COMPONENTS_GROUP:
            return getComponentsGroup();
         case SCAPackage.MODULE__COMPONENTS:
            return getComponents();
         case SCAPackage.MODULE__EXTERNAL_SERVICES:
            return getExternalServices();
         case SCAPackage.MODULE__NAME:
            return getName();
         case SCAPackage.MODULE__WIRES:
            return getWires();
         case SCAPackage.MODULE__ANY:
            return getAny();
         case SCAPackage.MODULE__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE__ENTRY_POINTS:
            getEntryPoints().clear();
            getEntryPoints().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE__COMPONENTS_GROUP:
            getComponentsGroup().clear();
            getComponentsGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE__COMPONENTS:
            getComponents().clear();
            getComponents().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE__EXTERNAL_SERVICES:
            getExternalServices().clear();
            getExternalServices().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.MODULE__WIRES:
            getWires().clear();
            getWires().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE__ENTRY_POINTS:
            getEntryPoints().clear();
            return;
         case SCAPackage.MODULE__COMPONENTS_GROUP:
            getComponentsGroup().clear();
            return;
         case SCAPackage.MODULE__COMPONENTS:
            getComponents().clear();
            return;
         case SCAPackage.MODULE__EXTERNAL_SERVICES:
            getExternalServices().clear();
            return;
         case SCAPackage.MODULE__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.MODULE__WIRES:
            getWires().clear();
            return;
         case SCAPackage.MODULE__ANY:
            getAny().clear();
            return;
         case SCAPackage.MODULE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE__ENTRY_POINTS:
            return entryPoints != null && !entryPoints.isEmpty();
         case SCAPackage.MODULE__COMPONENTS_GROUP:
            return componentsGroup != null && !componentsGroup.isEmpty();
         case SCAPackage.MODULE__COMPONENTS:
            return !getComponents().isEmpty();
         case SCAPackage.MODULE__EXTERNAL_SERVICES:
            return externalServices != null && !externalServices.isEmpty();
         case SCAPackage.MODULE__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.MODULE__WIRES:
            return wires != null && !wires.isEmpty();
         case SCAPackage.MODULE__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.MODULE__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   public List getComponents() {
      return getComponentsGroup().list(
            SCAPackage.eINSTANCE.getSCACoreRoot_Component());
   }

} // ModuleImpl
