/**
 * <copyright> </copyright>
 * 
 * $Id: SubsystemImpl.java,v 1.1 2006-03-31 21:58:48 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Subsystem;
import org.eclipse.stp.core.sca.SystemWire;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Subsystem</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.SubsystemImpl#getWires <em>Wires</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SubsystemImpl#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SubsystemImpl#getUri <em>Uri</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SubsystemImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class SubsystemImpl extends CompositeImpl implements Subsystem {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String    copyright    = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getWires() <em>Wires</em>}' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getWires()
    * @generated
    * @ordered
    */
   protected EList               wires        = null;

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap          any          = null;

   /**
    * The default value of the '{@link #getUri() <em>Uri</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getUri()
    * @generated
    * @ordered
    */
   protected static final String URI_EDEFAULT = null;

   /**
    * The cached value of the '{@link #getUri() <em>Uri</em>}' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getUri()
    * @generated
    * @ordered
    */
   protected String              uri          = URI_EDEFAULT;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap          anyAttribute = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected SubsystemImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getSubsystem();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getWires() {
      if (wires == null) {
         wires = new EObjectContainmentEList(SystemWire.class, this,
               SCAPackage.SUBSYSTEM__WIRES);
      }
      return wires;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this, SCAPackage.SUBSYSTEM__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getUri() {
      return uri;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setUri(String newUri) {
      String oldUri = uri;
      uri = newUri;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.SUBSYSTEM__URI, oldUri, uri));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.SUBSYSTEM__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.SUBSYSTEM__ENTRY_POINTS:
               return ((InternalEList) getEntryPoints()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.SUBSYSTEM__COMPONENTS_GROUP:
               return ((InternalEList) getComponentsGroup()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.SUBSYSTEM__COMPONENTS:
               return ((InternalEList) getComponents()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.SUBSYSTEM__EXTERNAL_SERVICES:
               return ((InternalEList) getExternalServices()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.SUBSYSTEM__WIRES:
               return ((InternalEList) getWires()).basicRemove(otherEnd, msgs);
            case SCAPackage.SUBSYSTEM__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.SUBSYSTEM__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SUBSYSTEM__ENTRY_POINTS:
            return getEntryPoints();
         case SCAPackage.SUBSYSTEM__COMPONENTS_GROUP:
            return getComponentsGroup();
         case SCAPackage.SUBSYSTEM__COMPONENTS:
            return getComponents();
         case SCAPackage.SUBSYSTEM__EXTERNAL_SERVICES:
            return getExternalServices();
         case SCAPackage.SUBSYSTEM__NAME:
            return getName();
         case SCAPackage.SUBSYSTEM__WIRES:
            return getWires();
         case SCAPackage.SUBSYSTEM__ANY:
            return getAny();
         case SCAPackage.SUBSYSTEM__URI:
            return getUri();
         case SCAPackage.SUBSYSTEM__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SUBSYSTEM__ENTRY_POINTS:
            getEntryPoints().clear();
            getEntryPoints().addAll((Collection) newValue);
            return;
         case SCAPackage.SUBSYSTEM__COMPONENTS_GROUP:
            getComponentsGroup().clear();
            getComponentsGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.SUBSYSTEM__COMPONENTS:
            getComponents().clear();
            getComponents().addAll((Collection) newValue);
            return;
         case SCAPackage.SUBSYSTEM__EXTERNAL_SERVICES:
            getExternalServices().clear();
            getExternalServices().addAll((Collection) newValue);
            return;
         case SCAPackage.SUBSYSTEM__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.SUBSYSTEM__WIRES:
            getWires().clear();
            getWires().addAll((Collection) newValue);
            return;
         case SCAPackage.SUBSYSTEM__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.SUBSYSTEM__URI:
            setUri((String) newValue);
            return;
         case SCAPackage.SUBSYSTEM__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SUBSYSTEM__ENTRY_POINTS:
            getEntryPoints().clear();
            return;
         case SCAPackage.SUBSYSTEM__COMPONENTS_GROUP:
            getComponentsGroup().clear();
            return;
         case SCAPackage.SUBSYSTEM__COMPONENTS:
            getComponents().clear();
            return;
         case SCAPackage.SUBSYSTEM__EXTERNAL_SERVICES:
            getExternalServices().clear();
            return;
         case SCAPackage.SUBSYSTEM__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.SUBSYSTEM__WIRES:
            getWires().clear();
            return;
         case SCAPackage.SUBSYSTEM__ANY:
            getAny().clear();
            return;
         case SCAPackage.SUBSYSTEM__URI:
            setUri(URI_EDEFAULT);
            return;
         case SCAPackage.SUBSYSTEM__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SUBSYSTEM__ENTRY_POINTS:
            return entryPoints != null && !entryPoints.isEmpty();
         case SCAPackage.SUBSYSTEM__COMPONENTS_GROUP:
            return componentsGroup != null && !componentsGroup.isEmpty();
         case SCAPackage.SUBSYSTEM__COMPONENTS:
            return !getComponents().isEmpty();
         case SCAPackage.SUBSYSTEM__EXTERNAL_SERVICES:
            return externalServices != null && !externalServices.isEmpty();
         case SCAPackage.SUBSYSTEM__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.SUBSYSTEM__WIRES:
            return wires != null && !wires.isEmpty();
         case SCAPackage.SUBSYSTEM__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.SUBSYSTEM__URI:
            return URI_EDEFAULT == null ? uri != null : !URI_EDEFAULT
                  .equals(uri);
         case SCAPackage.SUBSYSTEM__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (any: "); //$NON-NLS-1$
      result.append(any);
      result.append(", uri: "); //$NON-NLS-1$
      result.append(uri);
      result.append(", anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

   public List getComponents() {
      return getComponentsGroup().list(
            SCAPackage.eINSTANCE.getSCACoreRoot_ModuleComponent());
   }

} // SubsystemImpl
