/**
 * <copyright> </copyright>
 * 
 * $Id: ImplementationComponentItemProvider.java,v 1.2 2006-04-05 14:26:13 melder Exp $
 */
package org.eclipse.stp.core.sca.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.ImplementationComponent;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * This is the item provider adapter for a
 * {@link org.eclipse.stp.core.sca.ImplementationComponent} object. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class ImplementationComponentItemProvider extends ComponentItemProvider
      implements IEditingDomainItemProvider, IStructuredItemContentProvider,
      ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * This constructs an instance from a factory and a notifier. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ImplementationComponentItemProvider(AdapterFactory adapterFactory) {
      super(adapterFactory);
   }

   /**
    * This returns the property descriptors for the adapted class. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getPropertyDescriptors(Object object) {
      if (itemPropertyDescriptors == null) {
         super.getPropertyDescriptors(object);

      }
      return itemPropertyDescriptors;
   }

   /**
    * This specifies how to implement {@link #getChildren} and is used to deduce
    * an appropriate feature for an
    * {@link org.eclipse.emf.edit.command.AddCommand},
    * {@link org.eclipse.emf.edit.command.RemoveCommand} or
    * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Collection getChildrenFeatures(Object object) {
      if (childrenFeatures == null) {
         super.getChildrenFeatures(object);
         childrenFeatures.add(SCAPackage.eINSTANCE
               .getImplementationComponent_ImplementationGroup());
         childrenFeatures.add(SCAPackage.eINSTANCE
               .getImplementationComponent_Any());
         childrenFeatures.add(SCAPackage.eINSTANCE
               .getImplementationComponent_AnyAttribute());
      }
      return childrenFeatures;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EStructuralFeature getChildFeature(Object object, Object child) {
      // Check the type of the specified child object and return the proper
      // feature to use for
      // adding (see {@link AddCommand}) it as a child.

      return super.getChildFeature(object, child);
   }

   /**
    * This returns ImplementationComponent.gif. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public Object getImage(Object object) {
      return getResourceLocator()
            .getImage("full/obj16/ImplementationComponent"); //$NON-NLS-1$
   }

   /**
    * This returns the label text for the adapted class. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getText(Object object) {
      String label = ((ImplementationComponent) object).getName();
      return label == null || label.length() == 0 ? getString("_UI_ImplementationComponent_type") : //$NON-NLS-1$
            getString("_UI_ImplementationComponent_type") + " " + label; //$NON-NLS-1$ //$NON-NLS-2$
   }

   /**
    * This handles model notifications by calling {@link #updateChildren} to
    * update any cached children and by creating a viewer notification, which it
    * passes to {@link #fireNotifyChanged}. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public void notifyChanged(Notification notification) {
      updateChildren(notification);

      switch (notification.getFeatureID(ImplementationComponent.class)) {
         case SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION_GROUP:
         case SCAPackage.IMPLEMENTATION_COMPONENT__ANY:
         case SCAPackage.IMPLEMENTATION_COMPONENT__ANY_ATTRIBUTE:
            fireNotifyChanged(new ViewerNotification(notification, notification
                  .getNotifier(), true, false));
            return;
      }
      super.notifyChanged(notification);
   }

   /**
    * This adds to the collection of
    * {@link org.eclipse.emf.edit.command.CommandParameter}s describing all of
    * the children that can be created under this object. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void collectNewChildDescriptors(Collection newChildDescriptors,
         Object object) {
      super.collectNewChildDescriptors(newChildDescriptors, object);

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getImplementationComponent_ImplementationGroup(), FeatureMapUtil
            .createEntry(SCAPackage.eINSTANCE
                  .getImplementationComponent_Implementation(),
                  SCAFactory.eINSTANCE.createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getImplementationComponent_ImplementationGroup(), FeatureMapUtil
            .createEntry(SCAPackage.eINSTANCE
                  .getImplementationComponent_Implementation(),
                  SCAFactory.eINSTANCE.createJavaImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getImplementationComponent_ImplementationGroup(), FeatureMapUtil
            .createEntry(SCAPackage.eINSTANCE
                  .getImplementationComponent_Implementation(),
                  SCAFactory.eINSTANCE.createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getImplementationComponent_ImplementationGroup(), FeatureMapUtil
            .createEntry(SCAPackage.eINSTANCE
                  .getSCACoreRoot_ImplementationAbstract(),
                  SCAFactory.eINSTANCE.createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getImplementationComponent_ImplementationGroup(), FeatureMapUtil
            .createEntry(SCAPackage.eINSTANCE
                  .getSCACoreRoot_ImplementationUnknown(), SCAFactory.eINSTANCE
                  .createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getImplementationComponent_ImplementationGroup(), FeatureMapUtil
            .createEntry(SCAPackage.eINSTANCE
                  .getSCACoreRoot_ImplementationJava(), SCAFactory.eINSTANCE
                  .createJavaImplementation())));
   }

   /**
    * This returns the label text for
    * {@link org.eclipse.emf.edit.command.CreateChildCommand}. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getCreateChildText(Object owner, Object feature, Object child,
         Collection selection) {
      Object childFeature = feature;
      Object childObject = child;

      if (childFeature instanceof EStructuralFeature
            && FeatureMapUtil.isFeatureMap((EStructuralFeature) childFeature)) {
         FeatureMap.Entry entry = (FeatureMap.Entry) childObject;
         childFeature = entry.getEStructuralFeature();
         childObject = entry.getValue();
      }

      boolean qualify = childFeature == SCAPackage.eINSTANCE
            .getImplementationComponent_Implementation()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_ImplementationAbstract()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_ImplementationJava()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_ImplementationUnknown();

      if (qualify) {
         return getString("_UI_CreateChild_text2", //$NON-NLS-1$
               new Object[] { getTypeText(childObject),
                     getFeatureText(childFeature), getTypeText(owner) });
      }
      return super.getCreateChildText(owner, feature, child, selection);
   }

   /**
    * Return the resource locator for this item provider's resources. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ResourceLocator getResourceLocator() {
      return STPCorePlugin.INSTANCE;
   }

}
