/**
 * <copyright> </copyright>
 * 
 * $Id: SCAItemProviderAdapterFactory.java,v 1.1 2006-03-31 21:58:52 melder Exp $
 */
package org.eclipse.stp.core.sca.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.stp.core.sca.util.SCAAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support
 * Viewers. The adapters generated by this factory convert EMF adapter
 * notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets. Note that most of the
 * adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class SCAItemProviderAdapterFactory extends SCAAdapterFactory implements
      ComposeableAdapterFactory, IChangeNotifier, IDisposable {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String       copyright      = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * This keeps track of the root adapter factory that delegates to this
    * adapter factory. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ComposedAdapterFactory parentAdapterFactory;

   /**
    * This is used to implement
    * {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected IChangeNotifier        changeNotifier = new ChangeNotifier();

   /**
    * This keeps track of all the supported types checked by
    * {@link #isFactoryForType isFactoryForType}. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   protected Collection             supportedTypes = new ArrayList();

   /**
    * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public SCAItemProviderAdapterFactory() {
      supportedTypes.add(IEditingDomainItemProvider.class);
      supportedTypes.add(IStructuredItemContentProvider.class);
      supportedTypes.add(ITreeItemContentProvider.class);
      supportedTypes.add(IItemLabelProvider.class);
      supportedTypes.add(IItemPropertySource.class);
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.AbstractImplementation} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected AbstractImplementationItemProvider abstractImplementationItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.AbstractImplementation}. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createAbstractImplementationAdapter() {
      if (abstractImplementationItemProvider == null) {
         abstractImplementationItemProvider = new AbstractImplementationItemProvider(
               this);
      }

      return abstractImplementationItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.Binding} instances. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected BindingItemProvider bindingItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.Binding}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createBindingAdapter() {
      if (bindingItemProvider == null) {
         bindingItemProvider = new BindingItemProvider(this);
      }

      return bindingItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.ComponentType} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ComponentTypeItemProvider componentTypeItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.ComponentType}. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createComponentTypeAdapter() {
      if (componentTypeItemProvider == null) {
         componentTypeItemProvider = new ComponentTypeItemProvider(this);
      }

      return componentTypeItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.Composite} instances. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected CompositeItemProvider compositeItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.Composite}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createCompositeAdapter() {
      if (compositeItemProvider == null) {
         compositeItemProvider = new CompositeItemProvider(this);
      }

      return compositeItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.EntryPoint} instances. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EntryPointItemProvider entryPointItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.EntryPoint}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createEntryPointAdapter() {
      if (entryPointItemProvider == null) {
         entryPointItemProvider = new EntryPointItemProvider(this);
      }

      return entryPointItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.ExternalService} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ExternalServiceItemProvider externalServiceItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.ExternalService}. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createExternalServiceAdapter() {
      if (externalServiceItemProvider == null) {
         externalServiceItemProvider = new ExternalServiceItemProvider(this);
      }

      return externalServiceItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.ImplementationComponent} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ImplementationComponentItemProvider implementationComponentItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.ImplementationComponent}. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createImplementationComponentAdapter() {
      if (implementationComponentItemProvider == null) {
         implementationComponentItemProvider = new ImplementationComponentItemProvider(
               this);
      }

      return implementationComponentItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.Interface} instances. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected InterfaceItemProvider interfaceItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.Interface}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createInterfaceAdapter() {
      if (interfaceItemProvider == null) {
         interfaceItemProvider = new InterfaceItemProvider(this);
      }

      return interfaceItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.JavaImplementation} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected JavaImplementationItemProvider javaImplementationItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.JavaImplementation}. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createJavaImplementationAdapter() {
      if (javaImplementationItemProvider == null) {
         javaImplementationItemProvider = new JavaImplementationItemProvider(
               this);
      }

      return javaImplementationItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.JavaInterface} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected JavaInterfaceItemProvider javaInterfaceItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.JavaInterface}. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createJavaInterfaceAdapter() {
      if (javaInterfaceItemProvider == null) {
         javaInterfaceItemProvider = new JavaInterfaceItemProvider(this);
      }

      return javaInterfaceItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.Module} instances. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleItemProvider moduleItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.Module}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createModuleAdapter() {
      if (moduleItemProvider == null) {
         moduleItemProvider = new ModuleItemProvider(this);
      }

      return moduleItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.ModuleComponent} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleComponentItemProvider moduleComponentItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.ModuleComponent}. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createModuleComponentAdapter() {
      if (moduleComponentItemProvider == null) {
         moduleComponentItemProvider = new ModuleComponentItemProvider(this);
      }

      return moduleComponentItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.ModuleFragment} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleFragmentItemProvider moduleFragmentItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.ModuleFragment}. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createModuleFragmentAdapter() {
      if (moduleFragmentItemProvider == null) {
         moduleFragmentItemProvider = new ModuleFragmentItemProvider(this);
      }

      return moduleFragmentItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.ModuleReference} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleReferenceItemProvider moduleReferenceItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.ModuleReference}. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createModuleReferenceAdapter() {
      if (moduleReferenceItemProvider == null) {
         moduleReferenceItemProvider = new ModuleReferenceItemProvider(this);
      }

      return moduleReferenceItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.ModuleService} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleServiceItemProvider moduleServiceItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.ModuleService}. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createModuleServiceAdapter() {
      if (moduleServiceItemProvider == null) {
         moduleServiceItemProvider = new ModuleServiceItemProvider(this);
      }

      return moduleServiceItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.ModuleWire} instances. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleWireItemProvider moduleWireItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.ModuleWire}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createModuleWireAdapter() {
      if (moduleWireItemProvider == null) {
         moduleWireItemProvider = new ModuleWireItemProvider(this);
      }

      return moduleWireItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.Property} instances. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected PropertyItemProvider propertyItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.Property}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createPropertyAdapter() {
      if (propertyItemProvider == null) {
         propertyItemProvider = new PropertyItemProvider(this);
      }

      return propertyItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.PropertyValue} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected PropertyValueItemProvider propertyValueItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.PropertyValue}. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createPropertyValueAdapter() {
      if (propertyValueItemProvider == null) {
         propertyValueItemProvider = new PropertyValueItemProvider(this);
      }

      return propertyValueItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.PropertyValuesSet} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected PropertyValuesSetItemProvider propertyValuesSetItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.PropertyValuesSet}. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createPropertyValuesSetAdapter() {
      if (propertyValuesSetItemProvider == null) {
         propertyValuesSetItemProvider = new PropertyValuesSetItemProvider(this);
      }

      return propertyValuesSetItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.Reference} instances. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ReferenceItemProvider referenceItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.Reference}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createReferenceAdapter() {
      if (referenceItemProvider == null) {
         referenceItemProvider = new ReferenceItemProvider(this);
      }

      return referenceItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.ReferenceValue} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ReferenceValueItemProvider referenceValueItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.ReferenceValue}. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createReferenceValueAdapter() {
      if (referenceValueItemProvider == null) {
         referenceValueItemProvider = new ReferenceValueItemProvider(this);
      }

      return referenceValueItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.ReferenceValuesSet} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ReferenceValuesSetItemProvider referenceValuesSetItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.ReferenceValuesSet}. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createReferenceValuesSetAdapter() {
      if (referenceValuesSetItemProvider == null) {
         referenceValuesSetItemProvider = new ReferenceValuesSetItemProvider(
               this);
      }

      return referenceValuesSetItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.SCABinding} instances. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected SCABindingItemProvider scaBindingItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.SCABinding}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createSCABindingAdapter() {
      if (scaBindingItemProvider == null) {
         scaBindingItemProvider = new SCABindingItemProvider(this);
      }

      return scaBindingItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.SCACoreRoot} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected SCACoreRootItemProvider scaCoreRootItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.SCACoreRoot}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createSCACoreRootAdapter() {
      if (scaCoreRootItemProvider == null) {
         scaCoreRootItemProvider = new SCACoreRootItemProvider(this);
      }

      return scaCoreRootItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.Service} instances. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ServiceItemProvider serviceItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.Service}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createServiceAdapter() {
      if (serviceItemProvider == null) {
         serviceItemProvider = new ServiceItemProvider(this);
      }

      return serviceItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.SLSBBinding} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected SLSBBindingItemProvider slsbBindingItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.SLSBBinding}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createSLSBBindingAdapter() {
      if (slsbBindingItemProvider == null) {
         slsbBindingItemProvider = new SLSBBindingItemProvider(this);
      }

      return slsbBindingItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.Subsystem} instances. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected SubsystemItemProvider subsystemItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.Subsystem}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createSubsystemAdapter() {
      if (subsystemItemProvider == null) {
         subsystemItemProvider = new SubsystemItemProvider(this);
      }

      return subsystemItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.SystemWire} instances. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected SystemWireItemProvider systemWireItemProvider;

   /**
    * This creates an adapter for a {@link org.eclipse.stp.core.sca.SystemWire}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createSystemWireAdapter() {
      if (systemWireItemProvider == null) {
         systemWireItemProvider = new SystemWireItemProvider(this);
      }

      return systemWireItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.UnknownImplementation} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected UnknownImplementationItemProvider unknownImplementationItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.UnknownImplementation}. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createUnknownImplementationAdapter() {
      if (unknownImplementationItemProvider == null) {
         unknownImplementationItemProvider = new UnknownImplementationItemProvider(
               this);
      }

      return unknownImplementationItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.WebServiceBinding} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected WebServiceBindingItemProvider webServiceBindingItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.WebServiceBinding}. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createWebServiceBindingAdapter() {
      if (webServiceBindingItemProvider == null) {
         webServiceBindingItemProvider = new WebServiceBindingItemProvider(this);
      }

      return webServiceBindingItemProvider;
   }

   /**
    * This keeps track of the one adapter used for all
    * {@link org.eclipse.stp.core.sca.WSDLPortType} instances. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected WSDLPortTypeItemProvider wsdlPortTypeItemProvider;

   /**
    * This creates an adapter for a
    * {@link org.eclipse.stp.core.sca.WSDLPortType}. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter createWSDLPortTypeAdapter() {
      if (wsdlPortTypeItemProvider == null) {
         wsdlPortTypeItemProvider = new WSDLPortTypeItemProvider(this);
      }

      return wsdlPortTypeItemProvider;
   }

   /**
    * This returns the root adapter factory that contains this factory. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ComposeableAdapterFactory getRootAdapterFactory() {
      return parentAdapterFactory == null ? this : parentAdapterFactory
            .getRootAdapterFactory();
   }

   /**
    * This sets the composed adapter factory that contains this factory. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setParentAdapterFactory(
         ComposedAdapterFactory parentAdapterFactory) {
      this.parentAdapterFactory = parentAdapterFactory;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean isFactoryForType(Object type) {
      return supportedTypes.contains(type) || super.isFactoryForType(type);
   }

   /**
    * This implementation substitutes the factory itself as the key for the
    * adapter. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Adapter adapt(Notifier notifier, Object type) {
      return super.adapt(notifier, this);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object adapt(Object object, Object type) {
      if (isFactoryForType(type)) {
         Object adapter = super.adapt(object, type);
         if (!(type instanceof Class) || (((Class) type).isInstance(adapter))) {
            return adapter;
         }
      }

      return null;
   }

   /**
    * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void addListener(INotifyChangedListener notifyChangedListener) {
      changeNotifier.addListener(notifyChangedListener);
   }

   /**
    * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void removeListener(INotifyChangedListener notifyChangedListener) {
      changeNotifier.removeListener(notifyChangedListener);
   }

   /**
    * This delegates to {@link #changeNotifier} and to
    * {@link #parentAdapterFactory}. <!-- begin-user-doc --> <!-- end-user-doc
    * -->
    * 
    * @generated
    */
   public void fireNotifyChanged(Notification notification) {
      changeNotifier.fireNotifyChanged(notification);

      if (parentAdapterFactory != null) {
         parentAdapterFactory.fireNotifyChanged(notification);
      }
   }

   /**
    * This disposes all of the item providers created by this factory. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void dispose() {
      if (abstractImplementationItemProvider != null)
         abstractImplementationItemProvider.dispose();
      if (bindingItemProvider != null)
         bindingItemProvider.dispose();
      if (componentTypeItemProvider != null)
         componentTypeItemProvider.dispose();
      if (compositeItemProvider != null)
         compositeItemProvider.dispose();
      if (entryPointItemProvider != null)
         entryPointItemProvider.dispose();
      if (externalServiceItemProvider != null)
         externalServiceItemProvider.dispose();
      if (implementationComponentItemProvider != null)
         implementationComponentItemProvider.dispose();
      if (interfaceItemProvider != null)
         interfaceItemProvider.dispose();
      if (javaImplementationItemProvider != null)
         javaImplementationItemProvider.dispose();
      if (javaInterfaceItemProvider != null)
         javaInterfaceItemProvider.dispose();
      if (moduleItemProvider != null)
         moduleItemProvider.dispose();
      if (moduleComponentItemProvider != null)
         moduleComponentItemProvider.dispose();
      if (moduleFragmentItemProvider != null)
         moduleFragmentItemProvider.dispose();
      if (moduleReferenceItemProvider != null)
         moduleReferenceItemProvider.dispose();
      if (moduleServiceItemProvider != null)
         moduleServiceItemProvider.dispose();
      if (moduleWireItemProvider != null)
         moduleWireItemProvider.dispose();
      if (propertyItemProvider != null)
         propertyItemProvider.dispose();
      if (propertyValueItemProvider != null)
         propertyValueItemProvider.dispose();
      if (propertyValuesSetItemProvider != null)
         propertyValuesSetItemProvider.dispose();
      if (referenceItemProvider != null)
         referenceItemProvider.dispose();
      if (referenceValueItemProvider != null)
         referenceValueItemProvider.dispose();
      if (referenceValuesSetItemProvider != null)
         referenceValuesSetItemProvider.dispose();
      if (scaBindingItemProvider != null)
         scaBindingItemProvider.dispose();
      if (scaCoreRootItemProvider != null)
         scaCoreRootItemProvider.dispose();
      if (serviceItemProvider != null)
         serviceItemProvider.dispose();
      if (slsbBindingItemProvider != null)
         slsbBindingItemProvider.dispose();
      if (subsystemItemProvider != null)
         subsystemItemProvider.dispose();
      if (systemWireItemProvider != null)
         systemWireItemProvider.dispose();
      if (unknownImplementationItemProvider != null)
         unknownImplementationItemProvider.dispose();
      if (webServiceBindingItemProvider != null)
         webServiceBindingItemProvider.dispose();
      if (wsdlPortTypeItemProvider != null)
         wsdlPortTypeItemProvider.dispose();
   }

}
