/**
 * <copyright> </copyright>
 * 
 * $Id: SCASwitch.java,v 1.1 2006-03-31 21:58:50 melder Exp $
 */
package org.eclipse.stp.core.sca.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Binding;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.ImplementationComponent;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaImplementation;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.ModuleComponent;
import org.eclipse.stp.core.sca.ModuleFragment;
import org.eclipse.stp.core.sca.ModuleReference;
import org.eclipse.stp.core.sca.ModuleService;
import org.eclipse.stp.core.sca.ModuleWire;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.PropertyValue;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCABinding;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.SLSBBinding;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.Subsystem;
import org.eclipse.stp.core.sca.SystemWire;
import org.eclipse.stp.core.sca.UnknownImplementation;
import org.eclipse.stp.core.sca.WSDLPortType;
import org.eclipse.stp.core.sca.WebServiceBinding;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage
 * @generated
 */
public class SCASwitch {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String  copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached model package <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected static SCAPackage modelPackage;

   /**
    * Creates an instance of the switch. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public SCASwitch() {
      if (modelPackage == null) {
         modelPackage = SCAPackage.eINSTANCE;
      }
   }

   /**
    * Calls <code>caseXXX</code> for each class of the model until one returns
    * a non null result; it yields that result. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @return the first non-null result returned by a <code>caseXXX</code>
    *         call.
    * @generated
    */
   public Object doSwitch(EObject theEObject) {
      return doSwitch(theEObject.eClass(), theEObject);
   }

   /**
    * Calls <code>caseXXX</code> for each class of the model until one returns
    * a non null result; it yields that result. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @return the first non-null result returned by a <code>caseXXX</code>
    *         call.
    * @generated
    */
   protected Object doSwitch(EClass theEClass, EObject theEObject) {
      if (theEClass.eContainer() == modelPackage) {
         return doSwitch(theEClass.getClassifierID(), theEObject);
      } else {
         List eSuperTypes = theEClass.getESuperTypes();
         return eSuperTypes.isEmpty() ? defaultCase(theEObject) : doSwitch(
               (EClass) eSuperTypes.get(0), theEObject);
      }
   }

   /**
    * Calls <code>caseXXX</code> for each class of the model until one returns
    * a non null result; it yields that result. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @return the first non-null result returned by a <code>caseXXX</code>
    *         call.
    * @generated
    */
   protected Object doSwitch(int classifierID, EObject theEObject) {
      switch (classifierID) {
         case SCAPackage.ABSTRACT_IMPLEMENTATION: {
            AbstractImplementation abstractImplementation = (AbstractImplementation) theEObject;
            Object result = caseAbstractImplementation(abstractImplementation);
            if (result == null)
               result = caseImplementation(abstractImplementation);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.BINDING: {
            Binding binding = (Binding) theEObject;
            Object result = caseBinding(binding);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.COMPONENT: {
            Component component = (Component) theEObject;
            Object result = caseComponent(component);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.COMPONENT_TYPE: {
            ComponentType componentType = (ComponentType) theEObject;
            Object result = caseComponentType(componentType);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.COMPOSITE: {
            Composite composite = (Composite) theEObject;
            Object result = caseComposite(composite);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.ENTRY_POINT: {
            EntryPoint entryPoint = (EntryPoint) theEObject;
            Object result = caseEntryPoint(entryPoint);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.EXTERNAL_SERVICE: {
            ExternalService externalService = (ExternalService) theEObject;
            Object result = caseExternalService(externalService);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.IMPLEMENTATION: {
            Implementation implementation = (Implementation) theEObject;
            Object result = caseImplementation(implementation);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.IMPLEMENTATION_COMPONENT: {
            ImplementationComponent implementationComponent = (ImplementationComponent) theEObject;
            Object result = caseImplementationComponent(implementationComponent);
            if (result == null)
               result = caseComponent(implementationComponent);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.INTERFACE: {
            Interface interface_ = (Interface) theEObject;
            Object result = caseInterface(interface_);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.JAVA_IMPLEMENTATION: {
            JavaImplementation javaImplementation = (JavaImplementation) theEObject;
            Object result = caseJavaImplementation(javaImplementation);
            if (result == null)
               result = caseImplementation(javaImplementation);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.JAVA_INTERFACE: {
            JavaInterface javaInterface = (JavaInterface) theEObject;
            Object result = caseJavaInterface(javaInterface);
            if (result == null)
               result = caseInterface(javaInterface);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.MODULE: {
            Module module = (Module) theEObject;
            Object result = caseModule(module);
            if (result == null)
               result = caseModuleFragment(module);
            if (result == null)
               result = caseComposite(module);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.MODULE_COMPONENT: {
            ModuleComponent moduleComponent = (ModuleComponent) theEObject;
            Object result = caseModuleComponent(moduleComponent);
            if (result == null)
               result = caseComponent(moduleComponent);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.MODULE_FRAGMENT: {
            ModuleFragment moduleFragment = (ModuleFragment) theEObject;
            Object result = caseModuleFragment(moduleFragment);
            if (result == null)
               result = caseComposite(moduleFragment);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.MODULE_REFERENCE: {
            ModuleReference moduleReference = (ModuleReference) theEObject;
            Object result = caseModuleReference(moduleReference);
            if (result == null)
               result = caseReference(moduleReference);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.MODULE_SERVICE: {
            ModuleService moduleService = (ModuleService) theEObject;
            Object result = caseModuleService(moduleService);
            if (result == null)
               result = caseService(moduleService);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.MODULE_WIRE: {
            ModuleWire moduleWire = (ModuleWire) theEObject;
            Object result = caseModuleWire(moduleWire);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.PROPERTY: {
            Property property = (Property) theEObject;
            Object result = caseProperty(property);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.PROPERTY_VALUE: {
            PropertyValue propertyValue = (PropertyValue) theEObject;
            Object result = casePropertyValue(propertyValue);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.PROPERTY_VALUES_SET: {
            PropertyValuesSet propertyValuesSet = (PropertyValuesSet) theEObject;
            Object result = casePropertyValuesSet(propertyValuesSet);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.REFERENCE: {
            Reference reference = (Reference) theEObject;
            Object result = caseReference(reference);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.REFERENCE_VALUE: {
            ReferenceValue referenceValue = (ReferenceValue) theEObject;
            Object result = caseReferenceValue(referenceValue);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.REFERENCE_VALUES_SET: {
            ReferenceValuesSet referenceValuesSet = (ReferenceValuesSet) theEObject;
            Object result = caseReferenceValuesSet(referenceValuesSet);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.SCA_BINDING: {
            SCABinding scaBinding = (SCABinding) theEObject;
            Object result = caseSCABinding(scaBinding);
            if (result == null)
               result = caseBinding(scaBinding);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.SCA_CORE_ROOT: {
            SCACoreRoot scaCoreRoot = (SCACoreRoot) theEObject;
            Object result = caseSCACoreRoot(scaCoreRoot);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.SERVICE: {
            Service service = (Service) theEObject;
            Object result = caseService(service);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.SLSB_BINDING: {
            SLSBBinding slsbBinding = (SLSBBinding) theEObject;
            Object result = caseSLSBBinding(slsbBinding);
            if (result == null)
               result = caseBinding(slsbBinding);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.SUBSYSTEM: {
            Subsystem subsystem = (Subsystem) theEObject;
            Object result = caseSubsystem(subsystem);
            if (result == null)
               result = caseComposite(subsystem);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.SYSTEM_WIRE: {
            SystemWire systemWire = (SystemWire) theEObject;
            Object result = caseSystemWire(systemWire);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.UNKNOWN_IMPLEMENTATION: {
            UnknownImplementation unknownImplementation = (UnknownImplementation) theEObject;
            Object result = caseUnknownImplementation(unknownImplementation);
            if (result == null)
               result = caseImplementation(unknownImplementation);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.WEB_SERVICE_BINDING: {
            WebServiceBinding webServiceBinding = (WebServiceBinding) theEObject;
            Object result = caseWebServiceBinding(webServiceBinding);
            if (result == null)
               result = caseBinding(webServiceBinding);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         case SCAPackage.WSDL_PORT_TYPE: {
            WSDLPortType wsdlPortType = (WSDLPortType) theEObject;
            Object result = caseWSDLPortType(wsdlPortType);
            if (result == null)
               result = caseInterface(wsdlPortType);
            if (result == null)
               result = defaultCase(theEObject);
            return result;
         }
         default:
            return defaultCase(theEObject);
      }
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Abstract Implementation</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Abstract Implementation</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseAbstractImplementation(AbstractImplementation object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Binding</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Binding</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseBinding(Binding object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Component</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Component</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseComponent(Component object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Component Type</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Component Type</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseComponentType(ComponentType object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Composite</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Composite</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseComposite(Composite object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Entry Point</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Entry Point</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseEntryPoint(EntryPoint object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>External Service</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>External Service</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseExternalService(ExternalService object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Implementation</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Implementation</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseImplementation(Implementation object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Implementation Component</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Implementation Component</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseImplementationComponent(ImplementationComponent object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Interface</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Interface</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseInterface(Interface object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Java Implementation</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Java Implementation</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseJavaImplementation(JavaImplementation object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Java Interface</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Java Interface</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseJavaInterface(JavaInterface object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Module</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Module</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseModule(Module object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Module Component</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Module Component</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseModuleComponent(ModuleComponent object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Module Fragment</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Module Fragment</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseModuleFragment(ModuleFragment object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Module Reference</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Module Reference</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseModuleReference(ModuleReference object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Module Service</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Module Service</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseModuleService(ModuleService object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Module Wire</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Module Wire</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseModuleWire(ModuleWire object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Property</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Property</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseProperty(Property object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Property Value</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Property Value</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object casePropertyValue(PropertyValue object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Property Values Set</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Property Values Set</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object casePropertyValuesSet(PropertyValuesSet object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Reference</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Reference</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseReference(Reference object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Reference Value</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Reference Value</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseReferenceValue(ReferenceValue object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Reference Values Set</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Reference Values Set</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseReferenceValuesSet(ReferenceValuesSet object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Binding</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Binding</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseSCABinding(SCABinding object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Core Root</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Core Root</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseSCACoreRoot(SCACoreRoot object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Service</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Service</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseService(Service object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>SLSB Binding</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>SLSB Binding</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseSLSBBinding(SLSBBinding object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Subsystem</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Subsystem</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseSubsystem(Subsystem object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>System Wire</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>System Wire</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseSystemWire(SystemWire object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Unknown Implementation</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Unknown Implementation</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseUnknownImplementation(UnknownImplementation object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>Web Service Binding</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>Web Service Binding</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseWebServiceBinding(WebServiceBinding object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>WSDL Port Type</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>WSDL Port Type</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
    * @generated
    */
   public Object caseWSDLPortType(WSDLPortType object) {
      return null;
   }

   /**
    * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
    * <!-- begin-user-doc --> This implementation returns null; returning a
    * non-null result will terminate the switch, but this is the last case
    * anyway. <!-- end-user-doc -->
    * 
    * @param object
    *           the target of the switch.
    * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
    * @see #doSwitch(org.eclipse.emf.ecore.EObject)
    * @generated
    */
   public Object defaultCase(EObject object) {
      return null;
   }

} // SCASwitch
