/**
 * <copyright> </copyright>
 * 
 * $Id: SCAValidator.java,v 1.1 2006-03-31 21:58:50 melder Exp $
 */
package org.eclipse.stp.core.sca.util;

import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Binding;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.ImplementationComponent;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaImplementation;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.ModuleComponent;
import org.eclipse.stp.core.sca.ModuleFragment;
import org.eclipse.stp.core.sca.ModuleReference;
import org.eclipse.stp.core.sca.ModuleService;
import org.eclipse.stp.core.sca.ModuleWire;
import org.eclipse.stp.core.sca.OverrideOptions;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.PropertyValue;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCABinding;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.SLSBBinding;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.Subsystem;
import org.eclipse.stp.core.sca.SystemWire;
import org.eclipse.stp.core.sca.UnknownImplementation;
import org.eclipse.stp.core.sca.WSDLPortType;
import org.eclipse.stp.core.sca.WebServiceBinding;

/**
 * <!-- begin-user-doc --> The <b>Validator</b> for the model. <!--
 * end-user-doc -->
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage
 * @generated
 */
public class SCAValidator extends EObjectValidator {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String       copyright                       = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached model package <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final SCAValidator INSTANCE                        = new SCAValidator();

   /**
    * A constant for the
    * {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of
    * diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes}
    * from this package. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.emf.common.util.Diagnostic#getSource()
    * @see org.eclipse.emf.common.util.Diagnostic#getCode()
    * @generated
    */
   public static final String       DIAGNOSTIC_SOURCE               = "org.eclipse.stp.core.sca";                                                                           //$NON-NLS-1$

   /**
    * A constant with a fixed name that can be used as the base value for
    * additional hand written constants. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   private static final int         GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

   /**
    * A constant with a fixed name that can be used as the base value for
    * additional hand written constants in a derived class. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected static final int       DIAGNOSTIC_CODE_COUNT           = GENERATED_DIAGNOSTIC_CODE_COUNT;

   /**
    * The cached base package validator. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   protected XMLTypeValidator       xmlTypeValidator;

   /**
    * Creates an instance of the switch. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public SCAValidator() {
      super();
      xmlTypeValidator = XMLTypeValidator.INSTANCE;
   }

   /**
    * Returns the package of this validator switch. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   protected EPackage getEPackage() {
      return SCAPackage.eINSTANCE;
   }

   /**
    * Calls <code>validateXXX</code> for the corresonding classifier of the
    * model. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected boolean validate(int classifierID, Object value,
         DiagnosticChain diagnostics, Map context) {
      switch (classifierID) {
         case SCAPackage.ABSTRACT_IMPLEMENTATION:
            return validateAbstractImplementation(
                  (AbstractImplementation) value, diagnostics, context);
         case SCAPackage.BINDING:
            return validateBinding((Binding) value, diagnostics, context);
         case SCAPackage.COMPONENT:
            return validateComponent((Component) value, diagnostics, context);
         case SCAPackage.COMPONENT_TYPE:
            return validateComponentType((ComponentType) value, diagnostics,
                  context);
         case SCAPackage.COMPOSITE:
            return validateComposite((Composite) value, diagnostics, context);
         case SCAPackage.ENTRY_POINT:
            return validateEntryPoint((EntryPoint) value, diagnostics, context);
         case SCAPackage.EXTERNAL_SERVICE:
            return validateExternalService((ExternalService) value,
                  diagnostics, context);
         case SCAPackage.IMPLEMENTATION:
            return validateImplementation((Implementation) value, diagnostics,
                  context);
         case SCAPackage.IMPLEMENTATION_COMPONENT:
            return validateImplementationComponent(
                  (ImplementationComponent) value, diagnostics, context);
         case SCAPackage.INTERFACE:
            return validateInterface((Interface) value, diagnostics, context);
         case SCAPackage.JAVA_IMPLEMENTATION:
            return validateJavaImplementation((JavaImplementation) value,
                  diagnostics, context);
         case SCAPackage.JAVA_INTERFACE:
            return validateJavaInterface((JavaInterface) value, diagnostics,
                  context);
         case SCAPackage.MODULE:
            return validateModule((Module) value, diagnostics, context);
         case SCAPackage.MODULE_COMPONENT:
            return validateModuleComponent((ModuleComponent) value,
                  diagnostics, context);
         case SCAPackage.MODULE_FRAGMENT:
            return validateModuleFragment((ModuleFragment) value, diagnostics,
                  context);
         case SCAPackage.MODULE_REFERENCE:
            return validateModuleReference((ModuleReference) value,
                  diagnostics, context);
         case SCAPackage.MODULE_SERVICE:
            return validateModuleService((ModuleService) value, diagnostics,
                  context);
         case SCAPackage.MODULE_WIRE:
            return validateModuleWire((ModuleWire) value, diagnostics, context);
         case SCAPackage.PROPERTY:
            return validateProperty((Property) value, diagnostics, context);
         case SCAPackage.PROPERTY_VALUE:
            return validatePropertyValue((PropertyValue) value, diagnostics,
                  context);
         case SCAPackage.PROPERTY_VALUES_SET:
            return validatePropertyValuesSet((PropertyValuesSet) value,
                  diagnostics, context);
         case SCAPackage.REFERENCE:
            return validateReference((Reference) value, diagnostics, context);
         case SCAPackage.REFERENCE_VALUE:
            return validateReferenceValue((ReferenceValue) value, diagnostics,
                  context);
         case SCAPackage.REFERENCE_VALUES_SET:
            return validateReferenceValuesSet((ReferenceValuesSet) value,
                  diagnostics, context);
         case SCAPackage.SCA_BINDING:
            return validateSCABinding((SCABinding) value, diagnostics, context);
         case SCAPackage.SCA_CORE_ROOT:
            return validateSCACoreRoot((SCACoreRoot) value, diagnostics,
                  context);
         case SCAPackage.SERVICE:
            return validateService((Service) value, diagnostics, context);
         case SCAPackage.SLSB_BINDING:
            return validateSLSBBinding((SLSBBinding) value, diagnostics,
                  context);
         case SCAPackage.SUBSYSTEM:
            return validateSubsystem((Subsystem) value, diagnostics, context);
         case SCAPackage.SYSTEM_WIRE:
            return validateSystemWire((SystemWire) value, diagnostics, context);
         case SCAPackage.UNKNOWN_IMPLEMENTATION:
            return validateUnknownImplementation((UnknownImplementation) value,
                  diagnostics, context);
         case SCAPackage.WEB_SERVICE_BINDING:
            return validateWebServiceBinding((WebServiceBinding) value,
                  diagnostics, context);
         case SCAPackage.WSDL_PORT_TYPE:
            return validateWSDLPortType((WSDLPortType) value, diagnostics,
                  context);
         case SCAPackage.OVERRIDE_OPTIONS:
            return validateOverrideOptions((Object) value, diagnostics, context);
         case SCAPackage.MULTIPLICITY:
            return validateMultiplicity((String) value, diagnostics, context);
         case SCAPackage.OVERRIDE_OPTIONS_OBJECT:
            return validateOverrideOptionsObject((OverrideOptions) value,
                  diagnostics, context);
         default:
            return true;
      }
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateAbstractImplementation(
         AbstractImplementation abstractImplementation,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) abstractImplementation,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateBinding(Binding binding, DiagnosticChain diagnostics,
         Map context) {
      return validate_EveryDefaultConstraint((EObject) binding, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateComponent(Component component,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) component, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateComponentType(ComponentType componentType,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) componentType,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateComposite(Composite composite,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) composite, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateEntryPoint(EntryPoint entryPoint,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) entryPoint, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateExternalService(ExternalService externalService,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) externalService,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateImplementation(Implementation implementation,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) implementation,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateImplementationComponent(
         ImplementationComponent implementationComponent,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) implementationComponent,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateInterface(Interface interface_,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) interface_, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateJavaImplementation(
         JavaImplementation javaImplementation, DiagnosticChain diagnostics,
         Map context) {
      return validate_EveryDefaultConstraint((EObject) javaImplementation,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateJavaInterface(JavaInterface javaInterface,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) javaInterface,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateModule(Module module, DiagnosticChain diagnostics,
         Map context) {
      return validate_EveryDefaultConstraint((EObject) module, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateModuleComponent(ModuleComponent moduleComponent,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) moduleComponent,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateModuleFragment(ModuleFragment moduleFragment,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) moduleFragment,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateModuleReference(ModuleReference moduleReference,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) moduleReference,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateModuleService(ModuleService moduleService,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) moduleService,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateModuleWire(ModuleWire moduleWire,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) moduleWire, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateProperty(Property property,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) property, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validatePropertyValue(PropertyValue propertyValue,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) propertyValue,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validatePropertyValuesSet(
         PropertyValuesSet propertyValuesSet, DiagnosticChain diagnostics,
         Map context) {
      return validate_EveryDefaultConstraint((EObject) propertyValuesSet,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateReference(Reference reference,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) reference, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateReferenceValue(ReferenceValue referenceValue,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) referenceValue,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateReferenceValuesSet(
         ReferenceValuesSet referenceValuesSet, DiagnosticChain diagnostics,
         Map context) {
      return validate_EveryDefaultConstraint((EObject) referenceValuesSet,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateSCABinding(SCABinding scaBinding,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) scaBinding, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateSCACoreRoot(SCACoreRoot scaCoreRoot,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) scaCoreRoot,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateService(Service service, DiagnosticChain diagnostics,
         Map context) {
      return validate_EveryDefaultConstraint((EObject) service, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateSLSBBinding(SLSBBinding slsbBinding,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) slsbBinding,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateSubsystem(Subsystem subsystem,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) subsystem, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateSystemWire(SystemWire systemWire,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) systemWire, diagnostics,
            context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateUnknownImplementation(
         UnknownImplementation unknownImplementation,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) unknownImplementation,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateWebServiceBinding(
         WebServiceBinding webServiceBinding, DiagnosticChain diagnostics,
         Map context) {
      return validate_EveryDefaultConstraint((EObject) webServiceBinding,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateWSDLPortType(WSDLPortType wsdlPortType,
         DiagnosticChain diagnostics, Map context) {
      return validate_EveryDefaultConstraint((EObject) wsdlPortType,
            diagnostics, context);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateOverrideOptions(Object overrideOptions,
         DiagnosticChain diagnostics, Map context) {
      return true;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateMultiplicity(String multiplicity,
         DiagnosticChain diagnostics, Map context) {
      boolean result = validateMultiplicity_Enumeration(multiplicity,
            diagnostics, context);
      return result;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #validateMultiplicity_Enumeration
    */
   public static final Collection MULTIPLICITY__ENUMERATION__VALUES = wrapEnumerationValues(new Object[] {
         "0..1", //$NON-NLS-1$
         "1..1", //$NON-NLS-1$
         "0..n", //$NON-NLS-1$
         "1..n" //$NON-NLS-1$
                                                                    });

   /**
    * Validates the Enumeration constraint of '<em>Multiplicity</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateMultiplicity_Enumeration(String multiplicity,
         DiagnosticChain diagnostics, Map context) {
      boolean result = MULTIPLICITY__ENUMERATION__VALUES.contains(multiplicity);
      if (!result && diagnostics != null)
         reportEnumerationViolation(SCAPackage.eINSTANCE.getMultiplicity(),
               multiplicity, MULTIPLICITY__ENUMERATION__VALUES, diagnostics,
               context);
      return result;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean validateOverrideOptionsObject(
         OverrideOptions overrideOptionsObject, DiagnosticChain diagnostics,
         Map context) {
      return true;
   }

} // SCAValidator
