/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.properties;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.preferences.SCPreferenceConstants;
import org.eclipse.stp.sc.jaxws.properties.DefaultProjectPropertiesPageContents;
import org.eclipse.stp.sc.jaxws.properties.PreferenceStoreProxy;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPageContentsChangeListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class SCCXFPropertyPage extends DefaultProjectPropertiesPageContents implements IPropertyChangeListener {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(SCCXFPropertyPage.class);
	private RadioGroupFieldEditor soapOption; 
	private String currentSoapOption;
	IPageContentsChangeListener listener;
	
	public Control createContents(Composite parent) {
		super.createContents(parent);

		GridData gridData = new GridData(GridData.FILL_BOTH);
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, false));
		gridData.grabExcessHorizontalSpace = true;
		composite.setLayoutData(gridData);

		Group grpWsdlGen = new Group(composite, SWT.NONE);
        grpWsdlGen.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));
        grpWsdlGen.setLayout(new FillLayout());
        grpWsdlGen.setText(ScJaxWsResources.getString("pref.jaxws.cxf.wsdlgen.grp"));

        String soap11 = ScJaxWsResources.getString("pref.jaxws.cxf.wsdlgen.soap11.label");
        String soap12 = ScJaxWsResources.getString("pref.jaxws.cxf.wsdlgen.soap12.label");
        
        String[][] lnv = new String[][] {{soap11, SCPreferenceConstants.KEY_SOAP11}, {soap12, SCPreferenceConstants.KEY_SOAP12}};
        soapOption = new RadioGroupFieldEditor(SCPreferenceConstants.KEY_SOAP_OPTION, "", 2,
                lnv, grpWsdlGen, false);
        soapOption.setPropertyChangeListener(this);
        soapOption.setPreferenceStore(new PreferenceStoreProxy(project));
        soapOption.load();

		return composite;
	}

	public void propertyChange(PropertyChangeEvent event) {
		LOG.debug("event changed: " + event);
		currentSoapOption = (String)event.getNewValue();
		LOG.debug("new val: " + currentSoapOption);
		LOG.debug("old val: " + event.getOldValue());
		LOG.debug("source: " + event.getSource());
		LOG.debug("event prop: " + event.getProperty());
		if(listener != null){
			listener.whenValidStatusChanged();
		}
	}

	public void performDefault() {
		soapOption.loadDefault();
	}
	
	public void performOK() {
		try{
			if(project != null){
				project.setPersistentProperty(
						ScJaxWsPropertyConstants.PROPERTY_KEY_SOAP_OPTION,	
						currentSoapOption);
			}
		}catch(CoreException e){
			LOG.error(e);
		}
	}
}
