/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipes.stp.soas.deploy.runtime.cxf.internal.simplefrontend;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.stp.sc.cxf.natures.CxfSimpleFrontendNature;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackage;

public class DeployAdapterFactory extends org.eclipse.stp.soas.deploy.core.adapters.DeployAdapterFactory {

	public Object getAdapter(Object adaptableObject, Class adapterType) {
		Object adapted = null;
		if (IServiceDescriptor.class.isAssignableFrom(adapterType) ||
				IPackage.class.isAssignableFrom(adapterType)) {
			if(adaptableObject instanceof IJavaProject){
				adapted = getLogicalPackage(((IJavaProject)adaptableObject).getProject());
			}else{
				adapted = getLogicalPackage((IProject)adaptableObject);
			}
		}
		else {
			adapted = null;
		}
		return adapted;
	}

	IServiceDescriptor getLogicalPackage(IProject project){
		try{
			if(project != null && project.hasNature(CxfSimpleFrontendNature.NATURE_ID)){
				SimpleServiceDescriptor pkg = new SimpleServiceDescriptor();
				pkg.setProject(project);
				return pkg;
			}
		}catch(Exception ex){
			ex.printStackTrace();
			return null;
		}
		return null;
	}

}
