package org.eclipse.stp.soas.internal.deploy.ui.wizards;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.soas.internal.deploy.util.DeployUtilPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NewDeploymentProfileCreationPage extends WizardPage implements
	ISummaryDataSource {

	private final static String PROPERTY_DEPLOYMENT_VALUE = "deploymentProject";
	
	private final static String DEPLOYMENT_PROJECT_NAME = "Deployments";
	
	private final QualifiedName key = new QualifiedName("org.eclipse.stp","deploymentProject");
	
	private String smFileExtension;
	private Text txtName;

	private IProject project;
	
	public NewDeploymentProfileCreationPage(String pageName) {
		super(pageName);
		setTitle("Deployment Profile Name");
	}
	

	public void createControl(Composite parent) {
		
		Composite com = new Composite(parent, SWT.NONE);
		com.setLayout(new GridLayout(2, false));
		com.setLayoutData(new GridData(GridData.FILL_BOTH));
		new Label(com, SWT.NONE).setText("Name:");
		txtName = new Text(com, SWT.BORDER);
		txtName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		setControl(com);
	}
	
	public void init(String fileExtension) {
		smFileExtension = fileExtension;

		project = getDeploymentProject();
		try {
			if (project == null) {
				project = createProject();
				project.setPersistentProperty(key, PROPERTY_DEPLOYMENT_VALUE);
			}
			if(!project.isOpen()){
				project.open(new NullProgressMonitor());
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		

	}
	
	public String getFileName(){
		return txtName.getText();
	}
	
	public String getFullFileName() {
		// get current value of file name string and append the required
		// file name extension to it if it does not already have it.
		String fileName = getFileName();
		if (smFileExtension != null && !fileName.endsWith('.' + smFileExtension)) {
			fileName += '.' + smFileExtension;
		}
		return fileName;
	}
	
	public IFile getOutputFile() {
		
		return project.getFile(getFullFileName()); 
	}

	private IProject getDeploymentProject() {

		IProject[] projects = ResourcesPlugin.getWorkspace().getRoot()
				.getProjects();
		try {
			for (int i = 0; i < projects.length; i++) {

				if(projects[i].isOpen() 
						&& projects[i].getPersistentProperty(key) != null){
					return projects[i];
				}

			}
		} catch (CoreException e) {
			e.printStackTrace();
		}

		return null;
	}
	
	private IProject createProject() throws CoreException {
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		String prjName = generateProjectName(DEPLOYMENT_PROJECT_NAME);
		IProject prj = root.getProject(prjName);
		
		if (!prj.exists()) {
			prj.create(new NullProgressMonitor());
			prj.open(new NullProgressMonitor());
		}

		return prj;
	}
	
	private String generateProjectName(String prjNameBase){
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		String prjName = prjNameBase;
		int i = 1; 
		while(root.getProject(prjName).exists()){
			i++;
			prjName = prjNameBase + i;
		}
		
		return prjName;
	}
	
	
	public List getSummaryData() {
		List summaryData = new ArrayList(1);

		summaryData.add(new String[] {
				DeployUtilPlugin.getDefault().getResourceString(
						"WizardNewFileCreationPage.summary.fileName"), //$NON-NLS-1$
				getOutputFile().getFullPath().toString()});

		return summaryData;
	}
}
