/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core.bpel;

import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.XMLAccessible;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.Correlatable;
import org.eclipse.stp.b2j.core.jengine.internal.utils.XPathAccessible;

public class BPELCorrelatable implements Correlatable {

	BPELCorrelationSet cset;
	XMLAccessible setbuilder;
	
	public BPELCorrelatable(BPELCorrelationSet cset) {
		this.cset = cset;
		if (cset != null) {
			this.setbuilder = cset.getObjectBuilder();
		}
	}
	
	public boolean canAccept(Message m) {
		if (cset == null) {
			//we aren't correlating anything
			return true;
		}
		try {
			String xml = (String)m.get(0);
			XPathAccessible xpa = (XPathAccessible)setbuilder.ifromXML(xml);
			return cset.matches(xpa);
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}
	
}