/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.ui.internal.debug;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.IDebugModelPresentation;

/**
 * 
 * @author amiguel
 *
 * BPEL debugging source locator
 */
public class BPELSourceLocator extends DebugModelPresentation implements IPersistableSourceLocator, IDebugModelPresentation {

	String source = "";
	
	public BPELSourceLocator() {
		System.err.println("NEW BPEL SOURCE LOCATOR");
	}
	
	public BPELSourceLocator(String source) {
		System.err.println("NEW BPEL SOURCE LOCATOR "+source.hashCode());
		this.source = source;
	}

	public Object getSourceElement(IStackFrame stackFrame) {
		new Throwable().printStackTrace();
		System.err.println("BPEL SOURCE LOCATOR GET SOURCE ELEMENT "+source);
		return source;
	}
	
	public void setSource(String bpel) {
		source = bpel;
	}

	public String getMemento() throws CoreException {
		return source;
	}

	public void initializeFromMemento(String memento) throws CoreException {
		source = memento;
	}

	public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
	}
	
}