/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xml.internal;

import java.io.InputStream;

public class FastByteArrayInputStream extends InputStream {
	byte[] dat;
	int datlen;
	int pos;
	
	public FastByteArrayInputStream(byte[] b) {
		dat = b;
		datlen = dat.length;
		pos = 0;
	}	
	
	public int read() {
		if (pos == datlen) return -1;
		return dat[pos++];	
	}
	
	public void reset() {
		pos = 0;	
	}

	public int getPos() {
		return pos;	
	}

	public void setPos(int newpos) {
		if (newpos < 0 || newpos >= datlen) throw new ArrayIndexOutOfBoundsException("specified position "+newpos+" is out of bounds for array (0-"+datlen+")");  
		pos = newpos;
	}	
}