package org.eclipes.stp.soas.deploy.runtime.jaxwsri;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class JaxwsRIRuntimeResources {

	private static final String BUNDLE_KEY = "org.eclipes.stp.soas.deploy.runtime.jaxwsri.JaxwsRIRuntimeResources";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_KEY);
    private static final String IMAGE_FOLDER_RELATIVE_PATH = "icons/";

    protected JaxwsRIRuntimeResources() {
        // this is a base utility class, no public constructor allowed
    }

    /**
     * @return The CXF runtime plug-in's resource bundle
     */
    public static ResourceBundle getResourceBundle() {
        return RESOURCE_BUNDLE;
    }

    /**
     * @return The CXF runtime plug-in's bundle
     */
    public static Bundle getBundle() {
        return JaxwsRIRuntimePlugin.getDefault().getBundle();
    }

    /**
     * Returns the string from the plugin's resource bundle, or 'key' if not
     * found.
     */
    public static String getString(String key) {
        return getString(getResourceBundle(), key);
    }

    /**
     * Returns the string from the specified resource bundle, or 'key' if not
     * found.
     */
    public static final String getString(ResourceBundle bundle, String key) {
        try {
            // if no bundle specified, use global CXFResources
            return (bundle != null) ? bundle.getString(key)
                                    : getString(getResourceBundle(), key);
        } catch (MissingResourceException e) {
            // before giving up, make sure to try CXFResources
            if ((bundle != null) && (bundle != getResourceBundle())) {
                return getString(getResourceBundle(), key);
            }

            return key;
        }
    }

    
    
    
    /**
     * retrieve an image based on its name (from the plug-in standard image folder)
     * @param imageName
     * @return <code>ImageDescriptor</code> of the image if found or the standard missing image descvritor
     */
    public static ImageDescriptor getImageDescriptor(String imageName) {
        return getImageDescriptor(getBundle(), imageName);
    }

    /**
     * retrieve an image based on its name (from the plug-in standard image folder)
     * @param imageName
     * @return <code>ImageDescriptor</code> of the image if found or the standard missing image descriptor
     */
    public static final ImageDescriptor getImageDescriptor(Bundle bundle,
        String imageName) {
        URL url = getImageUrl(bundle, imageName);

        return (url != null) ? ImageDescriptor.createFromURL(url)
                             : ImageDescriptor.getMissingImageDescriptor();
    }

    /**
     * retrieve the URL of an image file based on its name (from the plug-in standard image folder)
     * @param imageName
     * @return <code>URL</code> of the image if found or null if not found
     */
    public static URL getImageUrl(String imageName) {
        return getImageUrl(getBundle(), imageName);
    }

    public static final URL getImageUrl(Bundle bundle, String imageName) {
        if (bundle == null) {
            bundle = JaxwsRIRuntimePlugin.getDefault().getBundle();
        }

        try {
            URL baseURL = bundle.getEntry("/");

            return new URL(baseURL, IMAGE_FOLDER_RELATIVE_PATH + imageName);
        } catch (MalformedURLException e) {
            //            LOG.warn("image URL invalid (image probably missing)", e);
            return null;
        }
    }
}
