/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipes.stp.soas.deploy.runtime.jaxwsri.core.internal;

import java.util.List;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;


/**
 * interface to deal with different JAX-WS RI version
 * @author jma
 *
 */
public interface IJaxwsRIVersionHandler {
	public boolean verifyInstallPath(IPath installPath);
	
	/**
	 * Gets the the classpath for JAX-WS RI runtime
	 * 
	 * @param installPath an installation path
	 * @return list of classpath entries required to start cxf server.
	 */
	public List<IRuntimeClasspathEntry> getRuntimeClasspath(IPath installPath);
}
