/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.sca.java.workspace;


import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.common.utils.RuntimeUtils;
import org.eclipse.stp.sc.common.workspace.AbstractNature;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.sca.java.ScaJavaResources;
import org.eclipse.stp.sc.sca.java.builders.JarBuilder;
import org.eclipse.stp.sc.sca.java.builders.ScaJavaToWsdlBuilder;
import org.eclipse.wst.server.core.IRuntime;

/**
 * @author jma
 *
 */
public class ScaJavaNature extends AbstractNature {

	public static final String SCA_KIT_LOCATION = "sca_kit_location";
	static String SCA_NATURE_ID = "org.eclipse.stp.sc.sca.java.nature";
	private static final LoggingProxy LOG = LoggingProxy.getlogger(ScaJavaNature.class);
	
	private IProject theProject; 
	
	
	public IProject getProject() {
        return theProject;
    }

    public void setProject(IProject value) {
        this.theProject = value;
    }
    
	/* (non-Javadoc)
	 * @see org.eclipse.stp.sc.common.workspace.AbstractNature#getNatureID()
	 */
	@Override
	public String getNatureID() {
		return SCA_NATURE_ID;
	}
	
	public void configure() throws CoreException {
		super.configure();
		WorkspaceManager.addBuilder(theProject, ScaJavaToWsdlBuilder.BUILDER_ID, 
        		WorkspaceManager.BuilderOrder.LAST);
		WorkspaceManager.addBuilder(theProject, JarBuilder.BUILDER_ID, 
				WorkspaceManager.BuilderOrder.LAST);
    }

    public void deconfigure() throws CoreException {
    	super.deconfigure();
    	WorkspaceManager.removeBuilder(theProject, JarBuilder.BUILDER_ID);
    	WorkspaceManager.removeBuilder(theProject, ScaJavaToWsdlBuilder.BUILDER_ID);
    }


	public void addToProject(IProject project) throws CoreException {
		
        addToProject(JavaCore.create(project));
        super.addToProject(project);
    }
	
	public void addToProject(IJavaProject jproject) throws CoreException {
        IProject project = jproject.getProject();
        //TODO:decoupling the runtime
        if (!project.hasNature(SCA_NATURE_ID)) {
            
//        	IPreferenceStore preferenceStore = ScaJavaPlugin.getDefault()
//			    .getPreferenceStore();
//        	String kitPath = preferenceStore.getString(ScaJavaPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT);
        	
        	String kitPath = RuntimeCore.getInstallPath(jproject.getProject()).makeAbsolute().toOSString();
            if (kitPath == null || kitPath.equals("")) {
            	if (System.getProperty(SCA_KIT_LOCATION) != null) {
            		kitPath = System.getProperty(SCA_KIT_LOCATION);
            	} else {
                    MessageDialog.openWarning(null,
                        ScaJavaResources.getString("sca.warning.title"),
                        ScaJavaResources.getString("sca.missing.install.text"));
                    return;
            	}
            }

            // complete the build path based on the kit used
            LOG.debug("adding libraries to project");
            completeJavaProjectBuildPath(jproject, kitPath);
        }
    }
	
//	private String getSubstitutionVarName() {
//		return "Tuscany_Lib";
//	}
	
	public IPath getKitRootDirectory(IProject prj) {
//    	IPath kitPath = null;
//    	String kitVar = null;
//    	IPreferenceStore preferenceStore = ScaJavaPlugin.getDefault()
//            .getPreferenceStore();
//        kitVar = preferenceStore.getString(ScaJavaPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT);
//    	if (kitVar != null && (!kitVar.trim().equals(""))) {
//    		kitPath = new Path(kitVar);
//    	}
		return  RuntimeCore.getInstallPath(prj);
    }

	/*
	private String registerInstallVarWithJavaProject(IJavaProject jProject) throws CoreException {
        String projectSubstitutionVarName = getSubstitutionVarName() + "_" + jProject.getProject().getName();
        
//        JavaCore.setClasspathVariable(projectSubstitutionVarName,
//        		getKitRootDirectory(jProject.getProject()), 
//        		null);
        return projectSubstitutionVarName;
    }
	*/
	
//	private static final char SEP = IPath.SEPARATOR;

//    private static final IPath LIBS_PATH = new Path(SEP + "lib" + SEP);

    private List<IClasspathEntry> getBuildPathEntries(IProject project) {
    	IRuntime runtime = RuntimeCore.getRuntime(project.getProject());
    	IClasspathEntry runtimeLib = RuntimeUtils.getRuntimeLib(runtime);
    	ArrayList<IClasspathEntry> clsLibs = new ArrayList<IClasspathEntry>();
    	clsLibs.add(runtimeLib);
//    	ITuscanyRuntime tuscanyRuntime = (ITuscanyRuntime)runtime.loadAdapter(ITuscanyRuntime.class, null);
//        List<IRuntimeClasspathEntry> libs = tuscanyRuntime.getRuntimeClasspath();
//        ArrayList<IClasspathEntry> clsLibs = new ArrayList<IClasspathEntry>();
//        for (IRuntimeClasspathEntry runtimeEntry : libs) {
//        	//workaround for tuscany1.0, which has duplicate jars in the manifest file
//        	if (clsLibs.contains(runtimeEntry.getClasspathEntry())) {
//        		continue;
//        	}
//        	if (runtimeEntry.getPath().toFile().exists()) {
//        	    clsLibs.add(runtimeEntry.getClasspathEntry());
//        	}
//        }
        
        
        return clsLibs;
    }
	
	private void completeJavaProjectBuildPath(IJavaProject jProject, String kitPath) {
		try {
		List<IClasspathEntry> entries = getBuildPathEntries(jProject.getProject()); 
		
		System.err.println("build entry to add:" + entries);
		
		WorkspaceManager.addEntriesToClassPath(jProject, 
				entries);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void removeFromProject(IProject project) throws CoreException {
		super.removeFromProject(project);
        if (project.hasNature(JavaCore.NATURE_ID)) {
            IJavaProject javaProject = JavaCore.create(project);
            removeFromProject(javaProject);
        }
    }

    public void removeFromProject(IJavaProject jproject) throws CoreException {
        // clean the build path based on the kit used
        clearJavaProjectBuildPath(jproject);
    }
    
    private static void clearJavaProjectBuildPath(IJavaProject javaProject) {
    	//TODO, remove build path once the sca java has been removed
    	
    }

}
