/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipes.stp.soas.deploy.runtime.tuscany.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.eclipes.stp.soas.deploy.runtime.tuscany.TuscanyRuntimePlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

/**
 * version hander for Tuscany SCA Java 1.0
 * 
 * @author jma
 *
 */
public class Tuscany10VersionHandler implements ITuscanyVersionHandler {

	private static String LIB_DIR_NAME = "lib";
	private static String FACADED_JAR_NAME = "tuscany-sca-manifest.jar"; 
	private static String VERSION_JAR_NAME = "tuscany-sca-all-1.0-incubating.jar";
	
	/**
	 * get the classpath defined from tuscany facade jar 
	 */
	public List<IRuntimeClasspathEntry> getRuntimeClasspath(IPath installPath) {
		List<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
		String libPath = installPath.append(LIB_DIR_NAME).makeAbsolute().toOSString();
		String filePath = libPath + File.separator + FACADED_JAR_NAME;
		String[] jars = RuntimeUtils.getLibEntryInManifest(filePath);
		for (String libName : jars) {
			IPath path = installPath.append(LIB_DIR_NAME).append(libName);
			cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry(path));
		}
		return cp;
	}
	
	
	public boolean verifyInstallPath(IPath installPath) {
		if (installPath == null)
			return false;

		if (!TuscanyRuntimePlugin.verifyInstallPath(installPath)) {
			return false;
		}
		//check for 1.0 jar
		String dir = installPath.toOSString();
		if (!dir.endsWith(File.separator))
			dir += File.separator;

		// look for /lib/tuscany-sca-manifest.jar 
		File t099jar = new File(dir + "lib" + File.separator + VERSION_JAR_NAME);
		if (!t099jar.exists()) {
			return false;
		}
		return true;
	}
	
	

}
