/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jface.action.IAction;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.actions.CreateActionBase;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.wizards.ScWizardDialog;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webservice.CreateWebServiceWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;


public class CreateWebServiceAction extends CreateActionBase {

    private static LoggingProxy LOG = LoggingProxy.getlogger(CreateWebServiceAction.class);

    public CreateWebServiceAction() {
        super();

        // TODO Auto-generated constructor stub
    }

    public void dispose() {
        // TODO Auto-generated method stub
    }

    public void init(IWorkbenchWindow window) {
        // TODO Auto-generated method stub
    }

    public void run(IAction action) {
        if (selection != null && !selection.isEmpty()) {
            try {
                
                if (!(selection.getFirstElement() instanceof IMember)) {
                    return;
                }
                IMember selMember = (IMember)selection.getFirstElement();
                IResource javaFileResource = selMember.getResource();

                if (javaFileResource != null && !isJavaEditorOpen(javaFileResource)) {
                    openJavaEditor(javaFileResource);
                }
                
                CreateWebServiceWizard wizard = new CreateWebServiceWizard(selMember);
                
                if (PreferencesAccessor.areAnnWizardsDisplaied()) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ScWizardDialog dialog = new ScWizardDialog(shell, wizard);
                    dialog.open();
                } else {
                    wizard.performFinish();
                }
            } catch (Exception e) {
                LOG.debug("exception on wizard run", e);
            }
        }
    }
}
