/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.actions;

import java.util.Iterator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IDisableJaxwsHook;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.workspace.ScJavaFirstNature;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.stp.sc.jaxws.workspace.ScWsdlFirstNature;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;


public class DisableScNatureAction implements IWorkbenchWindowActionDelegate {

	public static IAction disableAction = null; 
	
    private static final LoggingProxy LOG = LoggingProxy.getlogger(DisableScNatureAction.class);

    private ISelection selection;
    
    public void dispose() {
        // TODO Auto-generated method stub
    }

    public void init(IWorkbenchWindow window) {
    	
    }

    public void run(IAction action) {
    	
    	disableAction = action;
    	
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        
        Iterator iter = ((IStructuredSelection)selection).iterator();

        while (iter.hasNext()) {
            Object element = iter.next();

            IProject curProject = null;
            if (element instanceof IJavaProject) {
                curProject = ((IJavaProject)element).getProject();
            }else if(element instanceof IProject){
            	curProject = (IProject)element;
            }
            
            if(curProject != null){
            	try {
                	ScJavaFirstNature.removeFromProject(curProject);
                	ScWsdlFirstNature.removeFromProject(curProject);
                    ScNature.removeFromProject(curProject);
        			//invoke the runtime hook
                    RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
                    String runtimeType = RuntimeCore.getRuntimeType(curProject);
                    IDisableJaxwsHook disableHook = runtimeMgr.getDisableJaxwsHook(runtimeType);
        			if(disableHook != null){
        				disableHook.run(curProject);
        			}			
        			
                } catch (CoreException ce) {
                    LOG.error("error while disabling the SC nature", ce);
                }
            }
        }
        
        if(EnableScNatureAction.enableAction != null){
        	EnableScNatureAction.enableAction.setEnabled(true);
        }
        action.setEnabled(false);
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.selection = sel;
    }
    
}
