/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.utils;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stp.common.logging.LoggingProxy;

public class ScFolderGenerationUtils {

    //private static final String SC_GEN_ROOT_FOLDER = "ws";
    public static final LoggingProxy LOG = LoggingProxy.getlogger(ScFolderGenerationUtils.class);
    
    /*public static IFolder getBaseGenFolderForJavaFile(IFile seiFile) {
        // TODO
        throw new UnsupportedOperationException();
    }

    
    public static IFolder getBaseGenFolderForSei(IType sei) {
        
        IFolder baseGenFolder = sei.getResource().getProject().getFolder(SC_GEN_ROOT_FOLDER);
        
        String packageName = sei.getPackageFragment().getElementName();
        if (packageName != null && packageName.length() > 0 ) {
            baseGenFolder = baseGenFolder.getFolder(new Path(packageName.replace('.', File.separatorChar)));
        }
        
        baseGenFolder = baseGenFolder.getFolder(sei.getElementName().toLowerCase());
        
        return baseGenFolder;
        
    }*/
    
    public static IFolder getSrcGenFolder(IProject baseProject) {
        return baseProject.getFolder("src-gen");
    }
    
    public static IFolder getWsdlGenFolder(IProject baseProject) {
        return baseProject.getFolder("wsdl");
    }

    public static IFolder getDeployGenFolder(IProject baseProject) {
        return baseProject.getFolder("WebContent");
    }
    
    public static boolean makeSrcFolder(IFolder newSrcFolder) {
        try {
            IJavaProject javaProject = JavaCore.create(newSrcFolder.getProject());
            IClasspathEntry newClasspath = JavaCore.newSourceEntry(newSrcFolder.getFullPath());
            
            IClasspathEntry[] oldClasspathEntries = javaProject.getRawClasspath();
            
            boolean isFolderInClassPathAlready = false;
            for (int i = 0; i < oldClasspathEntries.length && !isFolderInClassPathAlready; i++ ) {
                if (oldClasspathEntries[i].getPath().equals(newSrcFolder.getFullPath())) {
                    isFolderInClassPathAlready = true;
                    LOG.info("the foldser ["
                              + newSrcFolder.getFullPath()
                              + "] is alreday in the project classpath");
                }
            }

            if (!isFolderInClassPathAlready) {
            
                IClasspathEntry[] newClasspathEntries = new IClasspathEntry[oldClasspathEntries.length + 1];
                for (int i = 0; i < oldClasspathEntries.length; i++ ) {
                    newClasspathEntries[i] = oldClasspathEntries[i];
                }
                newClasspathEntries[oldClasspathEntries.length] = newClasspath;
                    
                javaProject.setRawClasspath(newClasspathEntries, new NullProgressMonitor());
            }
        } catch (JavaModelException e) {
            LOG.error("failed to add a new source foder to project", e);
            return false;
        }
        
        return true;
    }
    

    /**
     * conveniance methods to create a folder and its parent container(s) if they do not exist yet.
     * note that the folder has to be located within the current workspace or it will not be created 
     *
     * @param aFolder the folder as a <code>IContainer</code> object
     * @return true if the creation succeeded, false otherwise (see logs for more details on failures)
     */
    public static boolean createFolder(IContainer aFolder) {
    
        try {
            aFolder.getProject().refreshLocal(IResource.DEPTH_INFINITE, null);
            if (!aFolder.isAccessible()) {
                createFolder(aFolder.getParent());
                
                if (aFolder instanceof IProject) {
                    IProject project = (IProject)aFolder;
                    project.create(null);
                    project.open(null);
                    LOG.debug("project created: " + project.getName());
    
                } else if (aFolder instanceof IFolder) {
                    LOG.debug("folder to create: " + aFolder.getFullPath());
                    ((IFolder)aFolder).create(false, true, null);
                } else {
                    LOG.debug("the IContainer passed is neither a folder nor a project: "
                              + aFolder.getFullPath());
                    return false;
                }
            }
        } catch (CoreException e) {
            LOG.debug("folder creation failed", e);
            return false;
        }
        return true;
    }
}
