/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.enablejaxws;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SelectProgramModeDialog extends Dialog {
	
	boolean isJavaFirst;
	
	Button btnJavaFirst;
	Button btnWsdlFirst;
	
	public SelectProgramModeDialog(Shell shell){
		super(shell);
	}
	
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite)super.createDialogArea(parent);
		
		btnJavaFirst = new Button(composite, SWT.RADIO);
		btnJavaFirst.setText("Java First Programming Mode");
		btnJavaFirst.setSelection(true);
		
		btnWsdlFirst = new Button(composite, SWT.RADIO);
		btnWsdlFirst.setText("WSDL First Programming Mode");
		btnWsdlFirst.setSelection(false);
		
	    return composite;
	}

	protected void okPressed() {
		if(btnJavaFirst.getSelection()){
			isJavaFirst = true;
		}else{
			isJavaFirst = false;
		}
		super.okPressed();
	}
	
	public boolean getIsJavaFirst(){
		return isJavaFirst;
	}
}
