/*
 * Copyright (c) 2007, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.MetamodelType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.diagram.edit.policies.SubProcessCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.SubProcessGraphicalNodeEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.SubProcessItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.figures.SubProcessBorderFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;
import org.eclipse.stp.bpmn.figures.connectionanchors.DefaultSizeNodeFigureEx;
import org.eclipse.stp.bpmn.figures.connectionanchors.IConnectionAnchorFactory;
import org.eclipse.stp.bpmn.figures.connectionanchors.impl.ConnectionAnchorFactory;
import org.eclipse.stp.bpmn.policies.ConnectionHandleEditPolicyEx;
import org.eclipse.stp.bpmn.policies.DelegateToCompartmentEditPolicy;
import org.eclipse.stp.bpmn.policies.ResizableSubProcessEditPolicy;
import org.eclipse.stp.bpmn.tools.EdgeConnectionValidator;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;

/**
 * @generated
 */
public class SubProcessEditPart extends ShapeNodeEditPart {
    /**
     * @notgenerated
     */
    public static final Dimension COLLAPSED_SIZE = new Dimension(111, 81);

    /**
     * @notgenerated
     */
    public static final Dimension EXPANDED_SIZE = new Dimension(121, 124);

    /**
     * @generated
     */
    public static final int VISUAL_ID = 2002;

    /**
     * @notgenerated
     */
    protected boolean needToUpdateContainer;

    /**
     * @generated
     */
    protected IFigure contentPane;

    /**
     * @generated
     */
    protected IFigure primaryShape;

    /**
     * @generated
     */
    public SubProcessEditPart(View view) {
        super(view);
    }

    /**
     * @generated
     */
    protected void createDefaultEditPoliciesGen() {
        installEditPolicy(EditPolicyRoles.CREATION_ROLE,
                new CreationEditPolicy() {

                    public Command getCommand(Request request) {
                        if (understandsRequest(request)) {
                            if (request instanceof CreateViewAndElementRequest) {
                                CreateElementRequestAdapter adapter = ((CreateViewAndElementRequest) request)
                                        .getViewAndElementDescriptor()
                                        .getCreateElementRequestAdapter();
                                IElementType type = (IElementType) adapter
                                        .getAdapter(IElementType.class);
                                if (type == BpmnElementTypes.Activity_2003) {
                                    EditPart compartmentEditPart = getChildBySemanticHint(BpmnVisualIDRegistry
                                            .getType(SubProcessSubProcessBorderCompartmentEditPart.VISUAL_ID));
                                    return compartmentEditPart == null ? null
                                            : compartmentEditPart
                                                    .getCommand(request);
                                }
                            }
                            return super.getCommand(request);
                        }
                        return null;
                    }
                });
        super.createDefaultEditPolicies();
        installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
                new SubProcessItemSemanticEditPolicy());
        installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE,
                new SubProcessGraphicalNodeEditPolicy());
        installEditPolicy(EditPolicyRoles.CANONICAL_ROLE,
                new SubProcessCanonicalEditPolicy());
        installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
    }

    /**
     * @notgenerated
     */
    protected void createDefaultEditPolicies() {
        createDefaultEditPoliciesGen();
        // no we don't want to generate an activity for a given subprocess
        // we want it to be in either the body or the border
        removeEditPolicy(EditPolicyRoles.CREATION_ROLE);

        // replace ConnectionHandleEditPolicy with our own
        installEditPolicy(EditPolicyRoles.CONNECTION_HANDLES_ROLE,
                createConnectionHandlerEditPolicy());

        // the compartment is not selectable anymore.
        // it looks like none of the containereidtpolicy gets called
        // because of that.
        // we use a mousedelegating edit policy to still call the proper
        // edit policy on the compartment.
        installEditPolicy(
                EditPolicy.CONTAINER_ROLE,
                new DelegateToCompartmentEditPolicy(
                        BpmnVisualIDRegistry
                                .getType(SubProcessSubProcessBodyCompartmentEditPart.VISUAL_ID),
                        EditPolicy.CONTAINER_ROLE));
    }
    /**
     * Ability to override the ConnectionHandleEditPolicy.
     * @generated NOT
     */
    protected DiagramAssistantEditPolicy createConnectionHandlerEditPolicy() {
        return new ConnectionHandleEditPolicyEx();
    }

    /**
     * @generated
     */
    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy() {

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child
                        .getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    /**
     * @generated
     */
    protected IFigure createNodeShape() {
        SubProcessFigure figure = new SubProcessFigure();
        return primaryShape = figure;
    }

    /**
     * @generated
     */
    public SubProcessFigure getPrimaryShape() {
        return (SubProcessFigure) primaryShape;
    }

    /**
     * @generated
     */
    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof SubProcessNameEditPart) {
            ((SubProcessNameEditPart) childEditPart).setLabel(getPrimaryShape()
                    .getFigureSubProcessNameFigure());
            return true;
        }
        if (childEditPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
            IFigure pane = getPrimaryShape().getFigureSubProcessBodyFigure();
            setupContentPane(pane); // FIXME each comparment should handle his
            // content pane in his own way
            pane
                    .add(((SubProcessSubProcessBodyCompartmentEditPart) childEditPart)
                            .getFigure());
            return true;
        }
        if (childEditPart instanceof SubProcessSubProcessBorderCompartmentEditPart) {
            IFigure pane = getPrimaryShape().getFigureSubProcessBorderFigure();
            setupContentPane(pane); // FIXME each comparment should handle his
            // content pane in his own way
            pane
                    .add(((SubProcessSubProcessBorderCompartmentEditPart) childEditPart)
                            .getFigure());
            return true;
        }
        return false;
    }

    /**
     * @generated
     */
    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
            IFigure pane = getPrimaryShape().getFigureSubProcessBodyFigure();
            pane
                    .remove(((SubProcessSubProcessBodyCompartmentEditPart) childEditPart)
                            .getFigure());
            return true;
        }
        if (childEditPart instanceof SubProcessSubProcessBorderCompartmentEditPart) {
            IFigure pane = getPrimaryShape().getFigureSubProcessBorderFigure();
            pane
                    .remove(((SubProcessSubProcessBorderCompartmentEditPart) childEditPart)
                            .getFigure());
            return true;
        }
        return false;
    }

    /**
     * @return An appropriate connection anchor factory
     * @generated NOT
     */
    protected IConnectionAnchorFactory getConnectionAnchorFactory() {
        return ConnectionAnchorFactory.INSTANCE;
    }

    /**
     * @generated NOT
     */
    protected NodeFigure createNodePlate() {
        return new DefaultSizeNodeFigureEx(getMapMode().DPtoLP(
                EXPANDED_SIZE.width), getMapMode().DPtoLP(EXPANDED_SIZE.height),
                getConnectionAnchorFactory()) {

            @Override
            public Rectangle getHandleBounds() {
                SubProcessFigure figure = getPrimaryShape();
                return figure.getVisibleBounds();
            }

            @Override
            public void setBounds(Rectangle rect) {
                int x = bounds.x, y = bounds.y;

                boolean resize = (rect.width != bounds.width)
                        || (rect.height != bounds.height), translate = (rect.x != x)
                        || (rect.y != y);

                if ((resize || translate) && isVisible())
                    erase();
                if (translate) {
                    int dx = rect.x - x;
                    int dy = rect.y - y;
                    primTranslate(dx, dy);
                }

                bounds.width = rect.width;
                bounds.height = rect.height;

                if (translate || resize) {
                    if (resize || needToUpdateContainer && translate)
                        invalidate();
                    fireFigureMoved();
                    repaint();
                }
            }
        };
    }

    /**
     * Creates figure for this edit part.
     * 
     * Body of this method does not depend on settings in generation model so
     * you may safely remove <i>generated</i> tag and modify it.
     * 
     * @generated
     */
    protected NodeFigure createNodeFigure() {
        NodeFigure figure = createNodePlate();
        figure.setLayoutManager(new StackLayout());
        IFigure shape = createNodeShape();
        figure.add(shape);
        contentPane = setupContentPane(shape);
        return figure;
    }

    /**
     * Default implementation treats passed figure as content pane. Respects
     * layout one may have set for generated figure.
     * 
     * @param nodeShape
     *            instance of generated figure class
     * @generated
     */
    protected IFigure setupContentPaneGen(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager(layout);
        }
        return nodeShape; // use nodeShape itself as contentPane
    }
    /**
     * Set the border to null
     * 
     * @param nodeShape
     *            instance of generated figure class
     * @generated NOT
     */
    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(0);
            nodeShape.setLayoutManager(layout);
            nodeShape.setBorder(null);
        }
        return nodeShape; // use nodeShape itself as contentPane
    }

    /**
     * @generated
     */
    public IFigure getContentPane() {
        if (contentPane != null) {
            return contentPane;
        }
        return super.getContentPane();
    }

    /**
     * @generated
     */
    public EditPart getPrimaryChildEditPart() {
        return getChildBySemanticHint(BpmnVisualIDRegistry
                .getType(SubProcessNameEditPart.VISUAL_ID));
    }

    /**
     * @generated
     */
    protected void addChildVisual(EditPart childEditPart, int index) {
        if (addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    /**
     * @generated
     */
    protected void removeChildVisual(EditPart childEditPart) {
        if (removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    /**
     * @generated
     */
    public class SubProcessFigure extends
            org.eclipse.stp.bpmn.figures.SubProcessFigure {

    	/**
    	 * @notgenerated
    	 * Calculates the minimum size from the different subfigures,
    	 * and the contained activities.
    	 */
        @Override
        public Dimension getMinimumSize(int wHint, int hHint) {
            return calcMinSize();
        }

        /**
         * @generated
         */
        public SubProcessFigure() {

            this.setForegroundColor(org.eclipse.draw2d.ColorConstants.black

            );

            createContents();
        }

        /**
         * @generated NOT since apparently the figures are all
         * initialized in there, we can as well give them their position
         * according to a BorderLayout.
         */
        private void createContents() {
            // this is necessary as the g gets cut out currently.
            // FIXME remove when bug 194944 is fixed.
            org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fig_0 = new org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel() {
                @Override
                public void setBounds(Rectangle rect) {
                    rect.height += MapModeUtil.getMapMode(this).DPtoLP(1);
                    super.setBounds(rect);
                }
            };
            fig_0.setTextWrap(true);
            fig_0.setText("");

            setFigureSubProcessNameFigure(fig_0);

            Object layData0 = null;

            this.add(fig_0, layData0);
            org.eclipse.stp.bpmn.figures.SubProcessBodyFigure fig_1 = new org.eclipse.stp.bpmn.figures.SubProcessBodyFigure() {
            };
            setFigureSubProcessBodyFigure(fig_1);

            Object layData1 = null;

            this.add(fig_1, layData1);
            org.eclipse.stp.bpmn.figures.SubProcessBorderFigure fig_2 = new org.eclipse.stp.bpmn.figures.SubProcessBorderFigure(
                    SubProcessEditPart.this.getMapMode());

            setFigureSubProcessBorderFigure(fig_2);

            Object layData2 = null;

            this.add(fig_2, layData2);
        }

        /**
         * @generated
         */
        private org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fSubProcessNameFigure;

        /**
         * @generated
         */
        public org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel getFigureSubProcessNameFigure() {
            return fSubProcessNameFigure;
        }

        /**
         * @generated
         */
        private void setFigureSubProcessNameFigure(
                org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fig) {
            fSubProcessNameFigure = fig;
        }

        /**
         * @generated
         */
        private org.eclipse.stp.bpmn.figures.SubProcessBodyFigure fSubProcessBodyFigure;

        /**
         * @generated
         */
        public org.eclipse.stp.bpmn.figures.SubProcessBodyFigure getFigureSubProcessBodyFigure() {
            return fSubProcessBodyFigure;
        }

        /**
         * @generated
         */
        private void setFigureSubProcessBodyFigure(
                org.eclipse.stp.bpmn.figures.SubProcessBodyFigure fig) {
            fSubProcessBodyFigure = fig;
        }

        /**
         * @generated
         */
        private org.eclipse.stp.bpmn.figures.SubProcessBorderFigure fSubProcessBorderFigure;

        /**
         * @generated
         */
        public org.eclipse.stp.bpmn.figures.SubProcessBorderFigure getFigureSubProcessBorderFigure() {
            return fSubProcessBorderFigure;
        }

        /**
         * @generated
         */
        private void setFigureSubProcessBorderFigure(
                org.eclipse.stp.bpmn.figures.SubProcessBorderFigure fig) {
            fSubProcessBorderFigure = fig;
        }

        /**
         * @generated
         */
        private boolean myUseLocalCoordinates = false;

        /**
         * @generated
         */
        protected boolean useLocalCoordinates() {
            return myUseLocalCoordinates;
        }

        /**
         * @generated
         */
        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            myUseLocalCoordinates = useLocalCoordinates;
        }

        /**
         * @notgenerated Draws loop marker and collapse handle.
         */
        public void paint(Graphics graphics) {
            super.paint(graphics);
            SubProcess model = (SubProcess) ((View) getModel()).getElement();

            paintCollapseHandle(graphics);
            SubProcessEditPart.this.paintLoopMarker(graphics);
            SubProcessEditPart.this.paintCompensationMarker(graphics);
        }

        /**
         * Draws &quot;+&quot; for collapsed and &quot;-&quot; for expanded
         * subprocess.
         * 
         * @notgenerated
         */
        private void paintCollapseHandle(Graphics graphics) {
        	
        	GraphicalEditPart bodyEditPart = null;
            for (Object object : children) {
                if (object instanceof SubProcessSubProcessBodyCompartmentEditPart) {
                    bodyEditPart = (GraphicalEditPart) object;
                    break;
                }
            }
            
        	if (bodyEditPart == null) { // been filtered
        		return; // we don't paint anything but the name of the subprocess.
        	}
            Rectangle bounds = getAbsCollapseHandleBounds();
            translateToRelative(bounds);
            int lineWidth = 1;
            bounds.shrink(lineWidth, lineWidth);
            graphics.drawRectangle(bounds);
            lineWidth = lineWidth * 2;
            graphics.setLineWidth(lineWidth);
            double delta = lineWidth;
            double y = bounds.y + bounds.height / 2.0;
            PrecisionPoint p1 = new PrecisionPoint(bounds.x + delta, y);
            PrecisionPoint p2 = new PrecisionPoint(bounds.x + bounds.width
                    - delta, y);
            graphics.drawLine(p1, p2);
            
            boolean isCollapsed = false;
            if (bodyEditPart == null) { // been filtered, we should not be there
            	isCollapsed = true;
            } else {
            	isCollapsed = ((Boolean) bodyEditPart
                    .getStructuralFeatureValue(NotationPackage.eINSTANCE
                            .getDrawerStyle_Collapsed())).booleanValue();
            }
            if (isCollapsed) {
                double x = bounds.x + bounds.width / 2.0;
                p1 = new PrecisionPoint(x, bounds.y + delta);
                p2 = new PrecisionPoint(x, bounds.y + bounds.height - delta);
                graphics.drawLine(p1, p2);
            }
            
/*            //add a little hint regarding the expanding style:
            boolean xpandOverlapse = true;//todo: read the value on the notation annotation
            if (xpandOverlapse) {
                //draw a small rectangle at the top of the marker
                //that reminds people of
                //the maximize rectangle of a standard window.
                double extraRectX = bounds.x + bounds.width * 3.0 / 4.0;
                double extraRectY = bounds.y + bounds.height / 12.0;
                PrecisionRectangle pr = new PrecisionRectangle();
                pr.setX(extraRectX);
                pr.setY(extraRectY);
                pr.setWidth(bounds.width / 4.0);
                pr.setHeight(bounds.height / 4.0);
                graphics.drawRectangle(pr);
                
                pr.setHeight(bounds.height / 8.0);
                graphics.setBackgroundColor(ColorConstants.black);
                graphics.fillRectangle(pr);
            }
            */
        }
    }
    
    /**
     * Called during the painting of the sub-process figure.
     * Checks if the sub-process has an incoming seqeunce flow that source is
     * an intermediate event handler for compensation.
     * In that case, paints a compensation marker on the left of the
     * collapse handle. The right of the collapse handle is already used by
     * the eventual loop marker.
     * <p>
     * Editors that extend the stp bpmn modeler can override this method
     * to handle other types of markers.
     * </p>
     * @notgenerated
     */
    protected void paintCompensationMarker(Graphics graphics) {
        SubProcess model = (SubProcess) ((View) getModel()).getElement();
        for (Object o : model.getIncomingEdges()) {
            SequenceEdge e = (SequenceEdge)o;
            if (e.getSource() != null && e.getSource() instanceof Activity) {
                Activity src = (Activity)e.getSource();
                if (src.getActivityType().getValue() ==
                            ActivityType.EVENT_INTERMEDIATE_COMPENSATION) {
                    int size = 18;
                    Rectangle bounds = getAbsBoundsWithoutBorder();
                    getPrimaryShape().translateToRelative(bounds);
                    Rectangle loopRect = new Rectangle();
                    loopRect.x = bounds.x + bounds.width/2 + size;
                    loopRect.y = bounds.y + bounds.height - size - 2;
                    loopRect.height = size;
                    loopRect.width = size;
                    
                    ActivityPainter.paintCompensation(graphics, loopRect);
                    
                    break;
                }
            }
        }
    }
    
    /**
     * Called during the painting of the sub-process figure.
     * Checks if the sub-process is looping and paint the standard loop
     * marker or the multiple instance loop marker in that case.
     * <p>
     * Editors that extend the stp bpmn modeler can override this method
     * to handle other types of markers.
     * </p>
     * @notgenerated
     */
    protected void paintLoopMarker(Graphics graphics) {
        SubProcess zmodel = (SubProcess) ((View) getModel()).getElement();
        if (zmodel.isLooping()) {
            int size = 20;
            Rectangle bounds = getAbsBoundsWithoutBorder();
            getPrimaryShape().translateToRelative(bounds);
            Rectangle loopRect = new Rectangle();
            loopRect.x = bounds.x + bounds.width/2 - size;
            loopRect.y = bounds.y + bounds.height -size;
            loopRect.height = size;
            loopRect.width = size;
            
            ActivityPainter.paintLoop(graphics,
                    new PrecisionRectangle(loopRect), getFigure());
        }
    }
    

    /**
     * @notgenerated
     */
    private static final int MIN_BODY_WIDTH = 50;

    /**
     * @notgenerated
     */
    private static final int MIN_BODY_HEIGHT = 50;

    /**
     * @notgenerated
     */
    public static final Insets INSETS = new Insets(5, 5, 5, 5);

    /**
     * @notgenerated
     */
    public Dimension calcMinSize() {
        List children = getChildren();
        GraphicalEditPart bodyEditPart = (GraphicalEditPart) getChildBySemanticHint(
                BpmnVisualIDRegistry.getType(SubProcessSubProcessBodyCompartmentEditPart.VISUAL_ID));
        GraphicalEditPart borderEditPart = (GraphicalEditPart) getChildBySemanticHint(
                BpmnVisualIDRegistry.getType(SubProcessSubProcessBorderCompartmentEditPart.VISUAL_ID));;
        GraphicalEditPart nameEditPart = (GraphicalEditPart) getChildBySemanticHint(
                BpmnVisualIDRegistry.getType(SubProcessNameEditPart.VISUAL_ID));;
        Dimension labelSize = nameEditPart.getFigure().getSize();

        Rectangle r1;
        boolean isCollapsed = ((Boolean) bodyEditPart
                .getStructuralFeatureValue(NotationPackage.eINSTANCE
                        .getDrawerStyle_Collapsed())).booleanValue();
        if (!isCollapsed) {
            r1 = getChildrenBounds(bodyEditPart);
            if (r1.height == 0) {
                r1.width = EXPANDED_SIZE.width;
                r1.height = EXPANDED_SIZE.height;
            }
        } else {
            return new Dimension(COLLAPSED_SIZE.width, COLLAPSED_SIZE.height);
        }

        // calculate the dimension of the border edit part.
        Dimension r2 = new Dimension();
        for (Object child : borderEditPart.getChildren()) {
            r2.width += ((IGraphicalEditPart) child).getFigure().getBounds().width;
            r2.height = Math.max(r2.height, 
                    ((IGraphicalEditPart) child).getFigure().getBounds().height);
        }
        

        return new Dimension(Math.max(r1.width, r2.width) + INSETS.getWidth(),
                labelSize.height + r1.height + INSETS.getHeight() + r2.height);
    }

    /**
     * Claculates rectangle that contains all children of the specified edit
     * part
     * 
     * @notgenerated
     * @param editPart
     * @return the cumulated size of the children
     */
    private Rectangle getChildrenBounds(EditPart editPart) {
        Rectangle r = new Rectangle();

        boolean isFirst = true;
        for (Object object : editPart.getChildren()) {
            GraphicalEditPart child = (GraphicalEditPart) object;
            if (!isFirst) {
                Rectangle dim = child.getFigure().getBounds().getCopy();
                r.union(dim);
            } else {
                r = child.getFigure().getBounds().getCopy();
                isFirst = false;
            }
        }
        return r;
    }

    @Override
    /**
     * @notgenerated
     */
    public EditPolicy getPrimaryDragEditPolicy() {
        return new ResizableSubProcessEditPolicy();
    }

    @Override
    /**
     * @notgenerated
     */
    protected void refreshBounds() {
        super.refreshBounds();
//        refreshChildrenLocation();
    }

    /**
     * Moves body comparment's children in case they exceed the bounds of the
     * compartment
     * 
     * @notgenerated
     */
    private void refreshChildrenLocation() {

        List children = getChildren();
        GraphicalEditPart bodyEditPart = null;
        GraphicalEditPart borderEditPart = null;
        GraphicalEditPart nameEditPart = null;
        for (Object object : children) {
            GraphicalEditPart editPart = (GraphicalEditPart) object;
            if (editPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
                bodyEditPart = editPart;
            } else if (editPart instanceof SubProcessSubProcessBorderCompartmentEditPart) {
                borderEditPart = editPart;
            } else if (editPart instanceof SubProcessNameEditPart) {
                nameEditPart = editPart;
            }
        }

        if (bodyEditPart != null) {
            boolean isCollapsed = ((Boolean) bodyEditPart
                    .getStructuralFeatureValue(NotationPackage.eINSTANCE
                            .getDrawerStyle_Collapsed())).booleanValue();
            if (!isCollapsed) {
                // move children only in expanded state
                int width = ((Integer) getStructuralFeatureValue(NotationPackage.eINSTANCE
                        .getSize_Width())).intValue();
                int totalHeight = ((Integer) getStructuralFeatureValue(NotationPackage.eINSTANCE
                        .getSize_Height())).intValue();

                int borderCompartmentHeight = borderEditPart.getFigure()
                        .getSize().height;
                int labelHeight = nameEditPart.getFigure().getSize().height;
                int height = totalHeight - borderCompartmentHeight
                        - labelHeight - MapModeUtil.getMapMode(getFigure()).DPtoLP(5);

                Point moveDelta = new Point(0, 0);

                bodyEditPart
                        .getStructuralFeatureValue(NotationPackage.eINSTANCE
                                .getSize_Width());
                Rectangle rect = getChildrenBounds(bodyEditPart);

                if (rect.x + rect.width > width - INSETS.getWidth()) {
                    moveDelta.x = rect.x + rect.width
                            - (width - INSETS.getWidth());
                }
                if (rect.y + rect.height > height - INSETS.getHeight()) {
                    moveDelta.y = rect.y + rect.height
                            - (height - INSETS.getHeight());
                }

                children = bodyEditPart.getChildren();
                if ((moveDelta.x + moveDelta.y) > 0 && children.size() > 0) {
                    CompositeCommand command = new CompositeCommand(
                            "Move subprocess' children");
                    for (int i = 0; i < children.size(); i++) {
                        GraphicalEditPart part = (GraphicalEditPart) children
                                .get(i);
                        Rectangle bound = part.getFigure().getBounds();
                        Point loc = new Point(bound.x - moveDelta.x, bound.y
                                - moveDelta.y);
                        Rectangle newBounds = new Rectangle(loc, bound
                                .getSize());
                        SetBoundsCommand cmd = new SetBoundsCommand(
                                getEditingDomain(), "Set bounds", part,
                                newBounds);
                        command.add(cmd);
                    }
                    // check if the current thread is not read-only.
                    if (!((TransactionalEditingDomainImpl)getEditingDomain()).
                    		getActiveTransaction().isReadOnly()) {
                    	getDiagramEditDomain().getDiagramCommandStack().
                    		execute(new ICommandProxy(command));
                    }

                }
            }
        }
    }

    /**
     * Returns bounds of figure without border figure included in absolute
     * coordinates .
     * 
     * @notgenerated
     * @return
     */
    protected Rectangle getAbsBoundsWithoutBorder() {
        boolean hasChildren = false;
        for (Object child : children) {
            if (child instanceof SubProcessSubProcessBorderCompartmentEditPart) {
                hasChildren = ((EditPart) child).getChildren().size() > 0;
                break;
            }
        }
        SubProcessFigure figure = getPrimaryShape();
        Rectangle theBounds = figure.getVisibleBounds();
        if (hasChildren) {
            // 18 is for the label of the handlers.
            int delta = (SubProcessBorderFigure.getFixedHeightDP(figure) - 18) / 2;
            theBounds.height = theBounds.height - delta;
        }
        figure.translateToAbsolute(theBounds);
        return theBounds;
    }

    /**
     * Calculates bounds of collapse handle in absolute coordinates.
     * 
     * @notgenerated
     * @return
     */
    public Rectangle getAbsCollapseHandleBounds() {
        double size = 20.0;
        RootEditPart rootEditPart = getRoot();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            double zoom = ((ScalableFreeformRootEditPart) rootEditPart)
                    .getZoomManager().getZoom();
            size = size * zoom;
        }

        Rectangle theBounds = getAbsBoundsWithoutBorder();
        PrecisionRectangle handleBounds = new PrecisionRectangle(theBounds);

        handleBounds.setX(handleBounds.x + (handleBounds.width - size) / 2);
        handleBounds.setY(handleBounds.y + handleBounds.height - size);
        handleBounds.setWidth(size);
        handleBounds.setHeight(size);

        SubProcess model = (SubProcess) ((View) getModel()).getElement();
        if (model.isLooping()) {
            handleBounds.setX(handleBounds.x + size / 2 + 1);
        }
        return handleBounds;
    }

    /**
     * @notgenerated
     */
    @Override
    protected void handleNotificationEvent(Notification notification) {
        if (notification.getEventType() == Notification.SET) {
            if (BpmnPackage.eINSTANCE.getActivity_Looping().equals(
                    notification.getFeature())) {
                figure.repaint();
            }
        }
        super.handleNotificationEvent(notification);
    }

    /**
     * @notgenerated
     */
    @Override
    public DragTracker getDragTracker(Request request) {
        return new TaskDragEditPartsTrackerEx(this);
    }

    /**
     * @notgenerated
     */
    @Override
    public Command getCommand(Request _request) {
        if (_request instanceof CreateUnspecifiedTypeConnectionRequest) {
            if (((CreateUnspecifiedTypeConnectionRequest) _request)
                    .getTargetEditPart() == null) {
                if (((IGraphicalEditPart) ((CreateUnspecifiedTypeConnectionRequest) _request).
                        getSourceEditPart()).resolveSemanticElement().eContainer().equals(this.resolveSemanticElement())) {
                    return getEditPolicy(EditPolicy.CONTAINER_ROLE).getCommand(_request);
                }
                Command co = super.getCommand(_request);
                return co;
            }
            Object model = ((CreateUnspecifiedTypeConnectionRequest) _request)
                    .getTargetEditPart().getModel();

            if ((model instanceof Node)) {
                List elTypes = ((CreateUnspecifiedTypeConnectionRequest) _request)
                        .getElementTypes();
                MetamodelType connType = (MetamodelType) BpmnElementTypes.MessagingEdge_3002;

                for (int i = 0; i < elTypes.size(); i++) {
                    if (elTypes.get(i) instanceof MetamodelType) {
                        connType = (MetamodelType) elTypes.get(i);
                        break;
                    }
                }

                if (connType == BpmnElementTypes.MessagingEdge_3002) {
                    // message connections for subprocess are not allowed.
                    return null;
                } else if (connType == BpmnElementTypes.SequenceEdge_3001) {
                    
                    if (_request instanceof CreateUnspecifiedTypeConnectionRequest) {
                        CreateUnspecifiedTypeConnectionRequest request = 
                            (CreateUnspecifiedTypeConnectionRequest) _request;

                        if (request.getSourceEditPart() != null) {
                            EditPart ancestor = request.getSourceEditPart().getParent();
                            while (ancestor != null) {
                                if (ancestor == this) {
                                    //the source edit part is contained.
                                    //delegate the call to the body compartment
                                    //that knows what to do to create a connection and an element
                                    //contained inside the sub-process:
                                    EditPart bodyCompartment =
                                        getChildBySemanticHint("" + 
                                           SubProcessSubProcessBodyCompartmentEditPart.VISUAL_ID);
                                    if (bodyCompartment != null) {
                                        return bodyCompartment.getCommand(request);
                                    }
                                    break;
                                }
                                ancestor = ancestor.getParent();
                            }
                        }
                        
                        // validate edge connection.
                        EdgeConnectionValidator edgeValidator = EdgeConnectionValidator.INSTANCE;
                        if (request.isDirectionReversed()) {
                            // do nothing
                        } else {
                            if ((request.getSourceEditPart() != null)
                                    && (request.getTargetEditPart() != null)) {
                                for (Iterator iter = request.getAllRequests()
                                        .iterator(); iter.hasNext();) {
                                    CreateConnectionRequest connectionRequest = (CreateConnectionRequest) iter
                                            .next();
                                    if (connectionRequest.getSourceEditPart() != null
                                            && connectionRequest
                                                    .getTargetEditPart() != null
                                            && connectionRequest
                                                    .getSourceEditPart() == request
                                                    .getSourceEditPart()
                                            && connectionRequest
                                                    .getTargetEditPart() == request
                                                    .getTargetEditPart()) {
                                        if (!edgeValidator.canConnect(request
                                                .getSourceEditPart(), request
                                                .getTargetEditPart())) {
                                            return null;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return super.getCommand(_request);
    }
}
