/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.multiplex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayOutBuffer
extends OutputStream {
    public static final int INFINITE_BUFFER = -1;
    public static final int DEFAULT_BUFFER = 400000;
    Object buffer_LOCK = new Object();
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    byte[] cache = null;
    boolean waiting_for_data = false;
    boolean waiting_for_space = false;
    IOException ioexception = null;
    int max_buffer = 400000;

    public ByteArrayOutBuffer() {
    }

    public ByteArrayOutBuffer(int max_buffer) {
        this.max_buffer = max_buffer;
    }

    public int size() {
        return this.bout.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] clearToByteArray(int max) throws IOException, InterruptedException {
        Object object = this.buffer_LOCK;
        synchronized (object) {
            if (this.cache == null) {
                this.cache = this.clearToByteArray();
            }
            if (max >= this.cache.length) {
                byte[] tmp = this.cache;
                this.cache = null;
                return tmp;
            }
            byte[] tmp = new byte[max];
            byte[] ncache = new byte[this.cache.length - max];
            System.arraycopy(this.cache, 0, tmp, 0, max);
            System.arraycopy(this.cache, max, ncache, 0, this.cache.length - max);
            this.cache = ncache;
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] clearToByteArray() throws IOException, InterruptedException {
        Object object = this.buffer_LOCK;
        synchronized (object) {
            while (this.bout.size() == 0) {
                IOException ioe;
                if (this.ioexception != null) {
                    ioe = new IOException("ByteArrayOutBuffer closed");
                    ioe.initCause(this.ioexception);
                }
                this.waiting_for_data = true;
                this.buffer_LOCK.wait();
                this.waiting_for_data = false;
                if (this.ioexception == null) continue;
                ioe = new IOException("ByteArrayOutBuffer closed");
                ioe.initCause(this.ioexception);
            }
            byte[] tmp = this.bout.toByteArray();
            this.bout.reset();
            if (this.waiting_for_space) {
                this.buffer_LOCK.notifyAll();
            }
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed(IOException err) {
        this.ioexception = err;
        Object object = this.buffer_LOCK;
        synchronized (object) {
            this.buffer_LOCK.notifyAll();
        }
    }

    public void close() {
        this.setClosed(new IOException("stream closed"));
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b) throws IOException {
        Object object = this.buffer_LOCK;
        synchronized (object) {
            if (this.ioexception != null) {
                IOException ioe = new IOException("ByteArrayOutBuffer closed");
                ioe.initCause(this.ioexception);
            }
            while (b.length + this.size() > this.max_buffer && this.size() != 0 && this.max_buffer >= 0) {
                this.waiting_for_space = true;
                try {
                    this.buffer_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
                this.waiting_for_space = false;
            }
            this.bout.write(b, 0, b.length);
            if (this.waiting_for_data) {
                this.buffer_LOCK.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.buffer_LOCK;
        synchronized (object) {
            if (this.ioexception != null) {
                IOException ioe = new IOException("ByteArrayOutBuffer closed");
                ioe.initCause(this.ioexception);
            }
            while (b.length + this.size() > this.max_buffer && this.size() != 0 && this.max_buffer >= 0) {
                this.waiting_for_space = true;
                try {
                    this.buffer_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
                this.waiting_for_space = false;
            }
            this.bout.write(b, off, len);
            if (this.waiting_for_data) {
                this.buffer_LOCK.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Object object = this.buffer_LOCK;
        synchronized (object) {
            if (this.ioexception != null) {
                IOException ioe = new IOException("ByteArrayOutBuffer closed");
                ioe.initCause(this.ioexception);
            }
            while (1 + this.size() > this.max_buffer && this.size() != 0 && this.max_buffer >= 0) {
                this.waiting_for_space = true;
                try {
                    this.buffer_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
                this.waiting_for_space = false;
            }
            this.bout.write(b);
            if (this.waiting_for_data) {
                this.buffer_LOCK.notify();
            }
        }
    }
}

