/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.mainengine.api;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.Version;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.api.SoapDaemonConnector;
import org.eclipse.stp.b2j.core.jengine.internal.utils.FileUtil;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;
import org.osgi.framework.Bundle;

public class PlatformSoapDaemonConnector
extends SoapDaemonConnector {
    public PlatformSoapDaemonConnector(SessionAddress address) throws Exception {
        super(address);
    }

    private void updateDaemon(TraceListener tl) throws Exception {
        if (!this.supportsVersion(Version.getVersion())) {
            if (tl != null) {
                tl.debug("Daemon does not support this version - updating Daemon now (this may take a while)");
            }
            URL plugin_dir = Platform.asLocalURL((URL)Platform.find((Bundle)B2jPlugin.getDefault().getBundle(), (IPath)new Path("/")));
            File jar_file = new File(String.valueOf(plugin_dir.getFile()) + "/b2j.jar");
            FileInputStream fin = new FileInputStream(jar_file);
            byte[] dat = FileUtil.readFileBinary(fin);
            fin.close();
            this.addVersion(Version.getVersion(), dat);
        }
    }

    public ControllerInterface newEngine(String description, TraceListener tl, JARDependency[] deps, SessionAddress address) throws Exception {
        this.updateDaemon(tl);
        return super.newEngine(description, tl, deps, address);
    }

    public SessionAddress newSubController(int id, JARDependency[] deps, SessionAddress engineaddress) throws Exception {
        this.updateDaemon(null);
        return super.newSubController(id, deps, engineaddress);
    }
}

