/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.api;

import java.io.File;

import org.eclipse.stp.b2j.core.jengine.internal.core.api.DaemonInterface;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SoapDaemon;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.api.PlatformSoapDaemonConnector;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

/**
 * 
 * @author amiguel
 *
 * A class to create and connect to engine daemons (which in turn can be used to create
 * engine instances)
 */
public class EngineFactory {
	public static final EngineFactory INSTANCE = new EngineFactory();
	
	/**
	 * Create an engine daemon for the main engine implementation
	 * @provisional
	 * @param enginedir the directory in which the main engine should be launched
	 * @param enginejar the b2j JAR which is required to run the main engine daemon
	 * @param port the TCP/IP port the main engine daemon should listen on
	 */
	public static void createMainEngineDaemon(File enginedir, File enginejar, int port) {
		SoapDaemon daemon = new SoapDaemon(enginedir,enginejar,port);
//		Daemon daemon = new Daemon(enginedir,enginejar,port);
	}
	
	/**
	 * Create a daemon connection to use to create main engine instances
	 * @provisional
	 * @param address the address of the Daemon to connect to
	 * @return a DaemonInterface to use to create new engine instances
	 */
	public static DaemonInterface connectToMainEngineDaemon(SessionAddress address) throws Exception {
//		return new org.eclipse.stp.b2j.core.jengine.internal.mainengine.api.DaemonConnector(address);
		return new PlatformSoapDaemonConnector(address);
	}

	/**
	 * Create a daemon connection to use to create mini engine instances
	 * @provisional
	 * @return a DaemonInterface to use to create new engine instances
	 */
	public static DaemonInterface connectToMiniEngineDaemon() {
		return new org.eclipse.stp.b2j.core.jengine.internal.miniengine.api.DaemonConnector();
	}
	
}