/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mutex;

import java.util.LinkedList;

/**
 * 
 * @author amiguel
 * 
 * A FCFS semaphore implementation
 */
public class QueuedSemaphore {

private class ThreadWait {
	public ThreadWait(int n) {
		count = n;	
	}
	int count;	
}

private Object LOCK = new Object();
private UnqueuedMutex SIGLOCK = new UnqueuedMutex();

LinkedList counts = new LinkedList();

int val = 0;

public QueuedSemaphore(int initial) {
	val = initial-1;
}

public void doWait(int count) {
	ThreadWait tw;
	
	synchronized(LOCK) {

		if (val >= count) {
			// thread can just go
			val -= count;
			
			return;
			
		} else {
			//thread has to wait for a signal
			count -= val;	
			val = 0;

			//Queue this thread	
			tw = new ThreadWait(count);
			
			SIGLOCK.lock();
			
			counts.addLast(tw);
		}
	}	

	synchronized (tw) {
			
		SIGLOCK.release();
			
		try {
			tw.wait();
			return;
		} catch (InterruptedException e) {
			e.printStackTrace();
			//return?
		}
	}
}

public void doSignal(int sig) {
	synchronized (LOCK) {
		val += sig;
		checkQueue();	
	}
}

private void checkQueue() {
	//UNSYNC because addSignal() is synchronized
	if (counts.isEmpty()) return;
	
	ThreadWait tw = (ThreadWait)counts.getFirst();
	int count = tw.count;

	while (val >= count) {
		val -= count;

		counts.removeFirst();		
		
		SIGLOCK.lock();
		synchronized (tw) {
			tw.notify();	
		}
		SIGLOCK.release();

		if (counts.isEmpty()) return;
		tw = (ThreadWait)counts.getFirst();
		count = tw.count;
	}
}
}