/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramPreferenceInitializer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class FilterDecorationsAction
extends AbstractActionHandler {
    public static final String ID = "FilterDecorationsAction";

    public FilterDecorationsAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    public FilterDecorationsAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public void init() {
        this.setId(ID);
        super.init();
        this.setEnabled(true);
        boolean b = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean(BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS);
        if (b) {
            String text = "Show decorations";
            this.setDescription(text);
            this.setToolTipText(text);
            this.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/showDecorations.gif"));
        } else {
            String text = "Hide decorations";
            this.setDescription(text);
            this.setToolTipText(text);
            this.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/hideDecorations.gif"));
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        boolean b = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean(BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS);
        BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().setValue(BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS, !b);
        this.refresh();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            IEditorPart part = page.getActiveEditor();
            EditPart ep = (EditPart)part.getAdapter(EditPart.class);
            ep.refresh();
            this.recursiveRefresh(ep);
        }
    }

    private void recursiveRefresh(EditPart part) {
        for (Object child : part.getChildren()) {
            ((EditPart)child).refresh();
            this.recursiveRefresh((EditPart)child);
        }
    }

    public void refresh() {
        boolean b = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean(BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS);
        if (b) {
            String text = "Show decorations";
            this.setDescription(text);
            this.setToolTipText(text);
            this.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/showDecorations.gif"));
        } else {
            String text = "Hide decorations";
            this.setDescription(text);
            this.setToolTipText(text);
            this.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/hideDecorations.gif"));
        }
        this.setEnabled(true);
    }
}

