/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/

/** 
 * Date          	Author             Changes 
 * 12 Oct 2006   	ASerhiychuk         Created 
 **/

package org.eclipse.stp.bpmn.tools;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.Vertex;

/**
 * @author Anton Serhiychuk
 * @author Mykola Peleshchyshyn Ability to press SHIFT 
 * during the drag to be able to move the shape from one container to another
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class TaskDragEditPartsTrackerEx extends DragEditPartsTrackerEx {
    
    /**
     * @param sourceEditPart The edit part for which the drag tracker is created.
     */
    public TaskDragEditPartsTrackerEx(EditPart sourceEditPart) {
        super(sourceEditPart);
    }


    /**
     * Determines wheter reparent is enabled. Returns <code>true</code> in
     * case if SHIFT is pressed and source edit part has Pool Compartment parent
     * and has no connections to other edit parts.
     * 
     * @return <code>true</code> in case if SHIFT is pressed and source edit
     *         part has Pool Compartment parent, <code>false</code> otherwise.
     */
    private boolean isReparentEnabled() {
    	if (getTargetEditPart() == null) {
    		return false;
    	}
        IGraphicalEditPart source = (IGraphicalEditPart) getSourceEditPart();
        if (source.resolveSemanticElement() instanceof Activity) {
        	Activity a = ((Activity) source.resolveSemanticElement());
        	if (!a.getIncomingEdges().isEmpty() || !a.getOutgoingEdges().isEmpty()) {
        		return false;
        	}
        	
        	Pool targetPool = getPool(((IGraphicalEditPart) getTargetEditPart()).
        			resolveSemanticElement());
        	if (targetPool == null) {
        		return false;
        	}
        	for (Object msg : a.getOutgoingMessages()) {
        		Activity target = ((MessagingEdge) msg).getTarget();
        		if (targetPool.equals(getPool(target))) {
        			// you cannot move your activity to a pool
        			// on which you have a connection
        			return false;
        		}
        	}
        		
        	for (Object msg : a.getIncomingMessages()) {
        		Activity src = ((MessagingEdge) msg).getSource();
        		if (targetPool.equals(getPool(src))) {
        			// you cannot move your activity to a pool
        			// on which you have a connection
        			return false;
        		}
        	}
        } else if (source.resolveSemanticElement() instanceof Artifact) {
            if (getTargetEditPart() == getSourceEditPart().getParent() ||
                    getTargetEditPart() == null) {
                return false;
            }
        	return true;
        }
        return getCurrentInput().isShiftKeyDown();
//                && (source.getParent() instanceof PoolPoolCompartmentEditPart || 
//                		source.getParent() instanceof SubProcessSubProcessBodyCompartmentEditPart)
//                && source.getSourceConnections().size() == 0
//                && source.getTargetConnections().size() == 0;
    }

    private Pool getPool(Object elt) {
    	if (elt instanceof Pool) {
    		return (Pool) elt;
    	}
    	if (elt instanceof Activity) {
    		if (((Activity) elt).getEventHandlerFor() != null) {
    			return getPool(((Activity) elt).getEventHandlerFor());
    		}
    	}
    	if (elt instanceof Vertex) {
    		return getPool(((Vertex) elt).getGraph());
    	}
    	return null;
    }
    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx#isMove()
     */
    @Override
    protected boolean isMove() {
        boolean isMove;
        if (isReparentEnabled()) {
            isMove = false;
        } else {
            isMove = true;
        }
        return isMove;
    }
    
    @Override
    protected boolean isCloneActive() {
    	return false;
    }
    
    protected Command getCommand() {
        if (isReparentEnabled()) {
            Request request = getTargetRequest();
            if (getTargetEditPart() != null) {
                request.setType(REQ_ADD);
                Command command = getTargetEditPart().getCommand(request);
                return command;
            } else {
                return UnexecutableCommand.INSTANCE;
    		}
    	} else {
    		return super.getCommand();
    	}
    }
}
