/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.internal.infrastructure.emf;

import java.io.PrintWriter;
import java.io.StringWriter;

class Snapshot extends RuntimeException {

   /**
    * Comment for <code>serialVersionUID</code>
    */
   private static final long serialVersionUID = -3485131336157897100L;

   public Snapshot() {
      super("Snapshot of invocation"); //$NON-NLS-1$
   }

   /*
    * (non-Javadoc)
    * 
    * @see java.lang.Throwable#printStackTrace()
    */
   public String getStackTraceString() {
      StringWriter writer = new StringWriter();
      PrintWriter printWriter = new PrintWriter(writer);
      super.printStackTrace(printWriter);
      return writer.toString();
   }
}
