/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

public interface IComponentCreationDataModelProperties extends
      IAbstractScribblerDataModelProperties {
   /**
    * [OPTIONAL] Name of the Component.
    * 
    * Type = {@link String} Defauted to Component1 or if that name is used then
    * Component2 ...
    */
   public static final String NAME      = "IComponentCreationDataModelProperties.NAME";     //$NON-NLS-1$

   /**
    * [REQUIRED] Property indicating the Container into which the component file
    * will be generated. This container must be a valid IContainer.
    * 
    * Type = {@link org.eclipse.core.resources.IContainer}
    */
   public static final String COMPOSITE = "IComponentCreationDataModelProperties.COMPOSITE"; //$NON-NLS-1$
}
