/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

/**
 * This interface describes WireTarget and WireSource elements that are derived
 * from a Component.
 * 
 * A client can cast to this interface for a WireTarget or a WireSource if they
 * return true for the isComponentOwned() API.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * 
 * @since 1.0
 * 
 * @see WireTarget#isComponentOwned()
 * @see WireSource#isComponentOwned()
 * 
 */
public interface ComponentWireHandle extends SCAObject {
   /**
    * Return the Component that owns this WireSource or WireTarget
    * 
    * @return Component
    */
   Component getOwningComponent();
}
