/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import java.util.List;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Property Values Set</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.PropertyValuesSet#getPropertyValues <em>Property Values</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.PropertyValuesSet#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getPropertyValuesSet()
 * @model extendedMetaData="name='PropertyValuesSet' kind='elementOnly'"
 * @extends SCAObject
 * @generated
 */
public interface PropertyValuesSet extends SCAObject {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Property Values</b></em>'
    * containment reference list. The list contents are of type
    * {@link org.eclipse.stp.core.sca.PropertyValue}. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Property Values</em>' containment reference
    * list isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Property Values</em>' containment
    *         reference list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getPropertyValuesSet_PropertyValues()
    * @model type="org.eclipse.stp.core.sca.PropertyValue" containment="true"
    *        resolveProxies="false" extendedMetaData="kind='element'
    *        name='property'"
    * @generated
    */
   List getPropertyValues();

   /**
    * Returns the value of the '<em><b>Any Attribute</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any Attribute</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any Attribute</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getPropertyValuesSet_AnyAttribute()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='attributeWildcard'
    *        wildcards='##any' name=':1' processing='lax'"
    * @generated
    */
   FeatureMap getAnyAttribute();

} // PropertyValuesSet
