/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

/**
 * This interface represents a target for a conceptual wire. A wire is a
 * conceptual mapping of a source element in the model to a target element.
 * 
 * <p>
 * The {@link #getName()} API will return the target URI to this target.
 * </p>
 * <p>
 * Use the {@link org.eclipse.stp.core.sca.SCAObject#getFlags()} method to get
 * the flags for this target and then you can use the
 * {@link org.eclipse.stp.core.sca.Flags#isBoundaryElement(int)} method to
 * determine if the target is a boundary target element.
 * </p>
 * <p>
 * Boundary elements are EntryPoint and ExternalService elements.
 * </p>
 * <p>
 * You can obtain a WireSource by using APIs on Composite or Component.
 * </p>
 * <p>
 * If the element returns true for {@link #isComponentOwned()} you may cast down
 * to {@link org.eclipse.stp.core.sca.ComponentWireHandle} for additional APIs.
 * </p>
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.WireSource
 * @see org.eclipse.stp.core.sca.Component
 * @see org.eclipse.stp.core.sca.Service
 * @see org.eclipse.stp.core.sca.ExternalService
 * @see org.eclipse.stp.core.sca.Composite#resolveWireTarget(String)
 * @see org.eclipse.stp.core.sca.Component#getWireTarget(Service)
 * @see org.eclipse.stp.core.sca.Component#getWireTarget(String)
 * @since 1.0
 */
public interface WireTarget extends SCAObject {
   /**
    * Return an Interface that is assigned to this target of a wire.
    * 
    * @return Interface
    */
   Interface getInterface();

   /**
    * NOT IMPLEMENTED.
    * 
    * @param wireSource
    *           The wireSource to test for compatibility.
    * @return True if and only if the Interface of the given wireSource is
    *         compatible with this WireTarget.
    */
   boolean matches(WireSource wireSource);

   /**
    * Return true if this target was resolved to an element in the SCA model. If
    * false is returned you can use the {@link SCAObject#getName()} method to
    * get the original target URI.
    * 
    * @return boolean
    */
   boolean isResolved();

   /**
    * Return true if this WireTarget originates from a {@link Component}. If
    * this returns true you may cast down to
    * 
    * @link ComponentWireHandle to get the owning Component.
    * @return boolean
    */
   boolean isComponentOwned();

}
