/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca.impl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.IConstants;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;

class ComponentWireTargetHandle extends ComponentWireHandleImpl implements
      WireTarget {
   private Service service;

   private String  serviceName;

   ComponentWireTargetHandle(Component configurable, Service service) {
      super(configurable);
      this.service = service;
   }

   ComponentWireTargetHandle(Component configurable, String serviceName) {
      super(configurable);
      this.serviceName = serviceName;
   }

   private String getServiceName() {
      return service == null ? serviceName : service.getName();
   }

   public Interface getInterface() {
      return isResolved() ? service.getInterface() : null;
   }

   public boolean matches(WireSource wireSource) {
      Assert.isNotNull(wireSource);
      if (getInterface() != null)
         return getInterface().equals(wireSource.getInterface());
      return false;
   }

   public int getFlags() {
      return IConstants.F_POSSIBLE_WIRE_TARGET;
   }

   public EObject getEObject() {
      /*
       * Should we use the component EObject or the service EObject?
       */
      return getOwningComponent().getEObject();
   }

   public void setName(String name) {
      Assert.isNotSupported("ComponentWireTargetHandle#setName(String)"); //$NON-NLS-1$
   }

   public String getName() {
      StringBuffer buf = new StringBuffer(getOwningComponent().getName());
      buf.append(IConstants.WIRE_PATH_SEP).append(getServiceName());
      return buf.toString();
   }

   public String toString() {
      return getName();
   }

   void destroy() {
      this.service = null;
      super.destroy();
   }

   /*
    * Test to ensure that the service still exists on the Component's
    * ComponentType.
    * 
    * @see org.eclipse.stp.core.sca.WireTarget#isResolved()
    */
   public boolean isResolved() {
      resolveService();
      return service != null;
   }

   private void resolveService() {
      ComponentType type = getOwningComponent().resolveComponentType();
      if (type != null) {
         Service test = type.getService(getServiceName());
         if (test != null) {
            service = test;
            serviceName = null;
         } else {
            if (service != null)
               serviceName = service.getName();
            service = null;
         }
      }
   }
}
